/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.google;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.geocoder.ConfigurationUtils;
import org.opennms.features.geocoder.GeocoderConfiguration;
import org.opennms.features.geocoder.GeocoderConfigurationException;

public class GoogleConfiguration
extends GeocoderConfiguration {
    static final String TIMEOUT_KEY = "timeout";
    static final String CLIENT_ID_KEY = "clientId";
    static final String SIGNATURE_KEY = "signature";
    static final String USE_SYSTEM_PROXY_KEY = "useSystemProxy";
    static final String USE_ENTERPRISE_CREDENTIALS_KEY = "useEnterpriseCredentials";
    static final String API_KEY_KEY = "apiKey";
    private int timeout;
    private boolean useEnterpriseCredentials;
    private boolean useSystemProxy;
    private String clientId;
    private String signature;
    private String apiKey;

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isUseEnterpriseCredentials() {
        return this.useEnterpriseCredentials;
    }

    public void setUseEnterpriseCredentials(boolean useEnterpriseCredentials) {
        this.useEnterpriseCredentials = useEnterpriseCredentials;
    }

    public boolean isUseSystemProxy() {
        return this.useSystemProxy;
    }

    public void setUseSystemProxy(boolean useSystemProxy) {
        this.useSystemProxy = useSystemProxy;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void validate() throws GeocoderConfigurationException {
        if (this.isUseEnterpriseCredentials()) {
            if (Strings.isNullOrEmpty((String)this.clientId)) {
                throw new GeocoderConfigurationException(CLIENT_ID_KEY, "Please provide a value");
            }
            if (Strings.isNullOrEmpty((String)this.signature)) {
                throw new GeocoderConfigurationException(SIGNATURE_KEY, "Please provide a value");
            }
        } else if (Strings.isNullOrEmpty((String)this.apiKey)) {
            throw new GeocoderConfigurationException(API_KEY_KEY, "Please provide a value");
        }
        if (this.timeout < 0) {
            throw new GeocoderConfigurationException(TIMEOUT_KEY, "The provided value must be >= 0");
        }
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(TIMEOUT_KEY, this.timeout);
        properties.put(USE_ENTERPRISE_CREDENTIALS_KEY, this.useEnterpriseCredentials);
        properties.put(CLIENT_ID_KEY, this.clientId);
        properties.put(SIGNATURE_KEY, this.signature);
        properties.put(API_KEY_KEY, this.apiKey);
        properties.put(USE_SYSTEM_PROXY_KEY, this.useSystemProxy);
        return properties;
    }

    public static GoogleConfiguration fromMap(Map<String, Object> properties) {
        GoogleConfiguration configuration = new GoogleConfiguration();
        configuration.setTimeout(ConfigurationUtils.getInteger(properties, (String)TIMEOUT_KEY, (Integer)0));
        configuration.setUseEnterpriseCredentials(ConfigurationUtils.getBoolean(properties, (String)USE_ENTERPRISE_CREDENTIALS_KEY, (Boolean)false));
        configuration.setUseSystemProxy(ConfigurationUtils.getBoolean(properties, (String)USE_SYSTEM_PROXY_KEY, (Boolean)false));
        configuration.setClientId((String)ConfigurationUtils.getValue(properties, (String)CLIENT_ID_KEY, null));
        configuration.setSignature((String)ConfigurationUtils.getValue(properties, (String)SIGNATURE_KEY, null));
        configuration.setApiKey((String)ConfigurationUtils.getValue(properties, (String)API_KEY_KEY, null));
        return configuration;
    }
}

