/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.google;

import com.google.code.geocoder.AdvancedGeoCoder;
import com.google.code.geocoder.GeocoderRequestBuilder;
import com.google.code.geocoder.model.GeocodeResponse;
import com.google.code.geocoder.model.GeocoderRequest;
import com.google.code.geocoder.model.GeocoderResult;
import java.io.IOException;
import java.security.InvalidKeyException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.features.geocoder.Coordinates;
import org.opennms.features.geocoder.GeocoderException;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.geocoder.TemporaryGeocoderException;
import org.opennms.features.geocoder.google.GoogleCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleGeocoderService
implements GeocoderService {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleGeocoderService.class);
    private final int timeout;
    private AdvancedGeoCoder m_geocoder = null;
    private String m_clientId = null;
    private String m_clientKey = null;

    public GoogleGeocoderService(int timeout) {
        this.timeout = Math.max(0, timeout);
    }

    public void setClientId(String clientId) {
        this.m_clientId = clientId;
    }

    public void setClientKey(String clientKey) {
        this.m_clientKey = clientKey;
    }

    public void ensureInitialized() throws GeocoderException {
        if (this.m_geocoder == null) {
            HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            if (this.notEmpty(this.m_clientId) && this.notEmpty(this.m_clientKey)) {
                try {
                    LOG.info("Initializing Google Geocoder using Client ID and Key.");
                    this.m_geocoder = new AdvancedGeoCoder(httpClient, this.m_clientId, this.m_clientKey);
                }
                catch (InvalidKeyException e) {
                    throw new GeocoderException("Unable to initialize Google Geocoder.", (Throwable)e);
                }
            }
            if (this.m_geocoder == null) {
                LOG.info("Initializing Google Geocoder using default configuration.");
                this.m_geocoder = new AdvancedGeoCoder(httpClient);
            }
            String httpProxyHost = System.getProperty("http.proxyHost");
            Integer httpProxyPort = SystemProperties.getInteger((String)"http.proxyPort");
            if (httpProxyHost != null && httpProxyPort != null) {
                LOG.info("Proxy configuration found, using {}:{} as HTTP proxy.", (Object)httpProxyHost, (Object)httpProxyPort);
                httpClient.getHostConfiguration().setProxy(httpProxyHost, httpProxyPort.intValue());
            } else {
                LOG.info("No proxy configuration found.");
            }
            httpClient.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(1, true));
            httpClient.getParams().setParameter("http.socket.timeout", (Object)this.timeout);
            LOG.info("Google Geocoder initialized.");
        }
    }

    private boolean notEmpty(String value) {
        return value != null && !"".equals(value);
    }

    public synchronized Coordinates getCoordinates(String address) throws GeocoderException {
        GeocodeResponse response;
        this.ensureInitialized();
        GeocoderRequest request = new GeocoderRequestBuilder().setAddress(address).setLanguage("en").getGeocoderRequest();
        try {
            response = this.m_geocoder.geocode(request);
        }
        catch (IOException e) {
            throw new TemporaryGeocoderException("Failed to get coordinates for " + address + " using the Google Geocoder.", (Throwable)e);
        }
        switch (response.getStatus()) {
            case OK: {
                return new GoogleCoordinates((GeocoderResult)response.getResults().get(0));
            }
            case OVER_QUERY_LIMIT: {
                throw new TemporaryGeocoderException("Failed to get coordinates for " + address + " using the Google Geocoder.  You have exceeded the daily usage limit.");
            }
        }
        throw new GeocoderException("Failed to get coordinates for " + address + " using Google Geocoder.  Response was: " + response.getStatus().toString());
    }
}

