/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.google;

import com.google.code.geocoder.model.GeocoderGeometry;
import com.google.code.geocoder.model.GeocoderResult;
import com.google.code.geocoder.model.LatLng;
import org.opennms.features.geocoder.Coordinates;
import org.opennms.features.geocoder.GeocoderException;

public class GoogleCoordinates
extends Coordinates {
    private static final long serialVersionUID = 5665827436870286281L;

    public GoogleCoordinates() {
    }

    public GoogleCoordinates(GeocoderResult result) throws GeocoderException {
        if (result == null) {
            throw new GeocoderException("No valid geocoder result found!");
        }
        GeocoderGeometry geometry = result.getGeometry();
        if (geometry == null) {
            throw new GeocoderException("No geometry found in Google geocoding response!");
        }
        LatLng latLng = geometry.getLocation();
        if (latLng == null) {
            throw new GeocoderException("No latitude/longitude found in Google geocoding response!");
        }
        this.setCoordinates(latLng.getLng().doubleValue(), latLng.getLat().doubleValue());
    }
}

