/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder;

import java.io.Serializable;
import org.opennms.features.geocoder.GeocoderException;

public class Coordinates
implements Serializable {
    private static final long serialVersionUID = -7242869661237596209L;
    public static final String BAD_COORDINATES = "-2147483648,-2147483648";
    private Double m_longitude;
    private Double m_latitude;

    public Coordinates() {
    }

    public Coordinates(String lonLat) throws GeocoderException {
        this.setCoordinates(lonLat);
    }

    public Coordinates(double longitude, double latitude) {
        this.setCoordinates(longitude, latitude);
    }

    public Coordinates(float longitude, float latitude) {
        this.setCoordinates(longitude, latitude);
    }

    public static Float[] splitCommaSeparatedFloats(String coordinateString) throws GeocoderException {
        Float[] coordinates;
        String[] separated = coordinateString.split(",");
        try {
            coordinates = new Float[]{Float.valueOf(separated[0]), Float.valueOf(separated[1])};
        }
        catch (NumberFormatException e) {
            throw new GeocoderException("Failed to parse coordinate string '" + coordinateString + "'", e);
        }
        return coordinates;
    }

    public static Double[] splitCommaSeparatedDoubles(String coordinateString) throws GeocoderException {
        Double[] coordinates;
        String[] separated = coordinateString.split(",");
        try {
            coordinates = new Double[]{Double.valueOf(separated[0]), Double.valueOf(separated[1])};
        }
        catch (NumberFormatException e) {
            throw new GeocoderException("Failed to parse coordinate string '" + coordinateString + "'", e);
        }
        return coordinates;
    }

    protected void setCoordinates(String lonLat) throws GeocoderException {
        if (lonLat == null) {
            throw new GeocoderException("Attempt to initialize a Coordinate with a null lon/lat string!");
        }
        Double[] coordinates = Coordinates.splitCommaSeparatedDoubles(lonLat);
        this.m_longitude = coordinates[0];
        this.m_latitude = coordinates[1];
    }

    protected void setCoordinates(double longitude, double latitude) {
        this.m_longitude = longitude;
        this.m_latitude = latitude;
    }

    protected void setCoordinates(float longitude, float latitude) {
        this.m_longitude = Float.valueOf(longitude).doubleValue();
        this.m_latitude = Float.valueOf(latitude).doubleValue();
    }

    public float getLongitude() {
        return this.m_longitude == null ? 0.0f : this.m_longitude.floatValue();
    }

    public float getLatitude() {
        return this.m_latitude == null ? 0.0f : this.m_latitude.floatValue();
    }

    public double getLatitudeAsDouble() {
        return this.m_latitude;
    }

    public double getLongitudeAsDouble() {
        return this.m_longitude;
    }

    public String toString() {
        return this.m_longitude + "," + this.m_latitude;
    }

    public int hashCode() {
        long prime = 31L;
        long result = 1L;
        result = 31L * result + Double.doubleToLongBits(this.m_longitude);
        result = 31L * result + Double.doubleToLongBits(this.m_latitude);
        return Long.valueOf(result).intValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Coordinates)) {
            return false;
        }
        Coordinates other = (Coordinates)obj;
        if (Double.doubleToLongBits(this.m_longitude) != Double.doubleToLongBits(other.m_longitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_latitude) == Double.doubleToLongBits(other.m_latitude);
    }
}

