/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder;

import java.io.Serializable;
import org.opennms.features.geocoder.GeocoderException;

public class Coordinates
implements Serializable {
    private static final long serialVersionUID = 2079876989978267336L;
    public static final String BAD_COORDINATES = "-2147483648,-2147483648";
    private float m_longitude;
    private float m_latitude;

    public Coordinates() {
    }

    public Coordinates(String lonLat) throws GeocoderException {
        this.setCoordinates(lonLat);
    }

    public Coordinates(float longitude, float latitude) {
        this.setCoordinates(longitude, latitude);
    }

    public static Float[] splitCommaSeparatedFloats(String coordinateString) throws GeocoderException {
        Float[] coordinates;
        String[] separated = coordinateString.split(",");
        try {
            coordinates = new Float[]{Float.valueOf(separated[0]), Float.valueOf(separated[1])};
        }
        catch (NumberFormatException e) {
            throw new GeocoderException("Failed to parse coordinate string '" + coordinateString + "'", e);
        }
        return coordinates;
    }

    protected void setCoordinates(String lonLat) throws GeocoderException {
        if (lonLat == null) {
            throw new GeocoderException("Attempt to initialize a Coordinate with a null lon/lat string!");
        }
        Float[] coordinates = Coordinates.splitCommaSeparatedFloats(lonLat);
        this.m_longitude = coordinates[0].floatValue();
        this.m_latitude = coordinates[1].floatValue();
    }

    protected void setCoordinates(float longitude, float latitude) {
        this.m_longitude = longitude;
        this.m_latitude = latitude;
    }

    public float getLongitude() {
        return this.m_longitude;
    }

    public float getLatitude() {
        return this.m_latitude;
    }

    public String toString() {
        return this.m_longitude + "," + this.m_latitude;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.m_longitude);
        result = 31 * result + Float.floatToIntBits(this.m_latitude);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Coordinates)) {
            return false;
        }
        Coordinates other = (Coordinates)obj;
        if (Float.floatToIntBits(this.m_longitude) != Float.floatToIntBits(other.m_longitude)) {
            return false;
        }
        return Float.floatToIntBits(this.m_latitude) == Float.floatToIntBits(other.m_latitude);
    }
}

