/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.rest.internal.classification;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FilenameHelper {
    public static final String REGEX_ALLOWED_CHAR = "^[a-zA-Z1-9_ .-]{1,}$";
    private Pattern p = Pattern.compile("^[a-zA-Z1-9_ .-]{1,}$");

    FilenameHelper() {
    }

    boolean isValidFileName(String filename) {
        if (filename == null || filename.startsWith(" ") || filename.endsWith(" ") || filename.trim().isEmpty()) {
            return false;
        }
        Matcher m = this.p.matcher(filename);
        return m.matches();
    }

    String createFilenameForGroupExport(int groupId, String requestedFilename) {
        return this.isValidFileName(requestedFilename) ? requestedFilename : groupId + "_rules.csv";
    }
}

