/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.rest.internal.classification;

import com.google.common.base.Strings;
import java.util.Objects;
import org.opennms.core.utils.IPLike;
import org.opennms.netmgt.flows.classification.error.ErrorTemplate;
import org.opennms.netmgt.flows.classification.error.Errors;
import org.opennms.netmgt.flows.classification.exception.ClassificationException;
import org.opennms.netmgt.flows.classification.persistence.api.Protocols;
import org.opennms.netmgt.flows.rest.classification.ClassificationRequestDTO;

public class ClassificationRequestDTOValidator {
    static void validate(ClassificationRequestDTO requestDTO) {
        if (Strings.isNullOrEmpty((String)requestDTO.getProtocol())) {
            throw new ClassificationException("protocol", Errors.RULE_PROTOCOL_IS_REQUIRED, new Object[0]);
        }
        if (Protocols.getProtocol((String)requestDTO.getProtocol()) == null) {
            throw new ClassificationException("protocol", Errors.RULE_PROTOCOL_DOES_NOT_EXIST, new Object[]{requestDTO.getProtocol()});
        }
        ClassificationRequestDTOValidator.validatePort("dstPort", requestDTO.getDstPort());
        ClassificationRequestDTOValidator.validateAddress("dstAddress", requestDTO.getDstAddress());
        ClassificationRequestDTOValidator.validatePort("srcPort", requestDTO.getSrcPort());
        ClassificationRequestDTOValidator.validateAddress("srcAddress", requestDTO.getSrcAddress());
        ClassificationRequestDTOValidator.validateAddress("exporterAddress", requestDTO.getExporterAddress());
    }

    private static void validatePort(String errorContext, String portValue) {
        Objects.requireNonNull(errorContext);
        try {
            int port = Integer.parseInt(portValue);
            if (port < 0 || port > 65536) {
                throw new ClassificationException(errorContext, Errors.RULE_PORT_VALUE_NOT_IN_RANGE, new Object[]{0, 65536});
            }
        }
        catch (NumberFormatException ex) {
            throw new ClassificationException(errorContext, new ErrorTemplate(null, "The provided port {0} is not a valid number."), new Object[]{portValue});
        }
    }

    private static void validateAddress(String errorContext, String address) {
        Objects.requireNonNull(errorContext);
        try {
            IPLike.matches((String)"8.8.8.8", (String)address);
        }
        catch (Exception ex) {
            throw new ClassificationException(errorContext, Errors.RULE_IP_ADDRESS_INVALID, new Object[]{address});
        }
    }
}

