/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.rest.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.flows.api.Conversation;
import org.opennms.netmgt.flows.api.ConversationKey;
import org.opennms.netmgt.flows.api.FlowRepository;
import org.opennms.netmgt.flows.filter.api.ExporterNodeFilter;
import org.opennms.netmgt.flows.filter.api.Filter;
import org.opennms.netmgt.flows.filter.api.NodeCriteria;
import org.opennms.netmgt.flows.filter.api.SnmpInterfaceIdFilter;
import org.opennms.netmgt.flows.filter.api.TimeRangeFilter;
import org.opennms.netmgt.flows.rest.FlowRestService;
import org.opennms.netmgt.flows.rest.model.FlowGraphUrlInfo;
import org.opennms.netmgt.flows.rest.model.FlowNodeDetails;
import org.opennms.netmgt.flows.rest.model.FlowNodeSummary;
import org.opennms.netmgt.flows.rest.model.FlowSeriesColumn;
import org.opennms.netmgt.flows.rest.model.FlowSeriesResponse;
import org.opennms.netmgt.flows.rest.model.FlowSnmpInterface;
import org.opennms.netmgt.flows.rest.model.FlowSummaryResponse;
import org.opennms.netmgt.model.OnmsCategory;
import org.springframework.transaction.support.TransactionOperations;

public class FlowRestServiceImpl
implements FlowRestService {
    private final FlowRepository flowRepository;
    private final NodeDao nodeDao;
    private final SnmpInterfaceDao snmpInterfaceDao;
    private final TransactionOperations transactionOperations;
    private String flowGraphUrl;

    public FlowRestServiceImpl(FlowRepository flowRepository, NodeDao nodeDao, SnmpInterfaceDao snmpInterfaceDao, TransactionOperations transactionOperations) {
        this.flowRepository = Objects.requireNonNull(flowRepository);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.snmpInterfaceDao = Objects.requireNonNull(snmpInterfaceDao);
        this.transactionOperations = Objects.requireNonNull(transactionOperations);
    }

    public Long getFlowCount(UriInfo uriInfo) {
        return (Long)FlowRestServiceImpl.waitForFuture(this.flowRepository.getFlowCount(FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters())));
    }

    public List<FlowNodeSummary> getFlowExporters() {
        return ((Stream)this.transactionOperations.execute(status -> this.nodeDao.findAllHavingFlows().stream())).map(n -> new FlowNodeSummary(n.getId(), n.getForeignId(), n.getForeignSource(), n.getLabel(), n.getCategories().stream().map(OnmsCategory::getName).collect(Collectors.toList()))).sorted(Comparator.comparingInt(FlowNodeSummary::getId)).collect(Collectors.toList());
    }

    public FlowNodeDetails getFlowExporter(Integer nodeId) {
        List ifaces = ((List)this.transactionOperations.execute(status -> this.snmpInterfaceDao.findAllHavingFlows(nodeId))).stream().map(iface -> new FlowSnmpInterface(iface.getIfIndex(), iface.getIfName(), iface.getIfAlias(), iface.getIfDescr())).collect(Collectors.toList());
        return new FlowNodeDetails(nodeId.intValue(), ifaces);
    }

    public FlowSummaryResponse getTopNApplications(int N, boolean includeOther, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        TimeRangeFilter timeRangeFilter = FlowRestServiceImpl.getRequiredTimeRangeFilter(filters);
        List summary = (List)FlowRestServiceImpl.waitForFuture(this.flowRepository.getTopNApplications(N, includeOther, filters));
        FlowSummaryResponse response = new FlowSummaryResponse();
        response.setStart(timeRangeFilter.getStart());
        response.setEnd(timeRangeFilter.getEnd());
        response.setHeaders((List)Lists.newArrayList((Object[])new String[]{"Application", "Bytes In", "Bytes Out"}));
        response.setRows(summary.stream().map(sum -> Arrays.asList(sum.getEntity(), sum.getBytesIn(), sum.getBytesOut())).collect(Collectors.toList()));
        return response;
    }

    public FlowSeriesResponse getTopNApplicationSeries(long step, int N, boolean includeOther, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        TimeRangeFilter timeRangeFilter = FlowRestServiceImpl.getRequiredTimeRangeFilter(filters);
        Table series = (Table)FlowRestServiceImpl.waitForFuture(this.flowRepository.getTopNApplicationsSeries(N, step, includeOther, filters));
        FlowSeriesResponse response = new FlowSeriesResponse();
        response.setStart(timeRangeFilter.getStart());
        response.setEnd(timeRangeFilter.getEnd());
        response.setColumns(series.rowKeySet().stream().map(d -> {
            FlowSeriesColumn column = new FlowSeriesColumn();
            column.setLabel((String)d.getValue());
            column.setIngress(d.isIngress());
            return column;
        }).collect(Collectors.toList()));
        FlowRestServiceImpl.populateResponseFromTable(series, response);
        return response;
    }

    public FlowSummaryResponse getTopNConversations(int N, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        TimeRangeFilter timeRangeFilter = FlowRestServiceImpl.getRequiredTimeRangeFilter(filters);
        List summary = (List)FlowRestServiceImpl.waitForFuture(this.flowRepository.getTopNConversations(N, filters));
        FlowSummaryResponse response = new FlowSummaryResponse();
        response.setStart(timeRangeFilter.getStart());
        response.setEnd(timeRangeFilter.getEnd());
        response.setHeaders((List)Lists.newArrayList((Object[])new String[]{"Location", "Protocol", "Source IP", "Source Port", "Dest. IP", "Dest. Port", "Application", "Bytes In", "Bytes Out"}));
        response.setRows(summary.stream().map(sum -> {
            Conversation convo = (Conversation)sum.getEntity();
            ConversationKey key = convo.getKey();
            return Lists.newArrayList((Object[])new Object[]{key.getLocation(), key.getProtocol(), key.getSrcIp(), key.getSrcPort(), key.getDstIp(), key.getDstPort(), convo.getApplication(), sum.getBytesIn(), sum.getBytesOut()});
        }).collect(Collectors.toList()));
        return response;
    }

    public FlowSeriesResponse getTopNConversationsSeries(long step, int N, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        TimeRangeFilter timeRangeFilter = FlowRestServiceImpl.getRequiredTimeRangeFilter(filters);
        Table series = (Table)FlowRestServiceImpl.waitForFuture(this.flowRepository.getTopNConversationsSeries(N, step, filters));
        FlowSeriesResponse response = new FlowSeriesResponse();
        response.setStart(timeRangeFilter.getStart());
        response.setEnd(timeRangeFilter.getEnd());
        response.setColumns(series.rowKeySet().stream().map(d -> {
            Conversation convo = (Conversation)d.getValue();
            ConversationKey key = convo.getKey();
            String applicationTag = convo.getApplication() != null ? String.format(" [%s]", convo.getApplication()) : "";
            FlowSeriesColumn column = new FlowSeriesColumn();
            column.setLabel(String.format("%s:%d <-> %s:%d%s", key.getSrcIp(), key.getSrcPort(), key.getDstIp(), key.getDstPort(), applicationTag));
            column.setIngress(d.isIngress());
            return column;
        }).collect(Collectors.toList()));
        FlowRestServiceImpl.populateResponseFromTable(series, response);
        return response;
    }

    protected static List<Filter> getFiltersFromQueryString(MultivaluedMap<String, String> queryParams) {
        String exporterNodeCriteria;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        String start = (String)queryParams.getFirst((Object)"start");
        long startMs = start != null ? Long.parseLong(start) : -TimeUnit.HOURS.toMillis(4L);
        String end = (String)queryParams.getFirst((Object)"end");
        long endMs = end != null ? Long.parseLong(end) : System.currentTimeMillis();
        endMs = FlowRestServiceImpl.getEffectiveEnd(endMs);
        startMs = FlowRestServiceImpl.getEffectiveStart(startMs, endMs);
        filters.add((Filter)new TimeRangeFilter(startMs, endMs));
        String ifIndexStr = (String)queryParams.getFirst((Object)"ifIndex");
        if (ifIndexStr != null) {
            int ifIndex = Integer.parseInt(ifIndexStr);
            filters.add((Filter)new SnmpInterfaceIdFilter(ifIndex));
        }
        if ((exporterNodeCriteria = (String)queryParams.getFirst((Object)"exporterNode")) != null) {
            try {
                filters.add((Filter)new ExporterNodeFilter(new NodeCriteria(exporterNodeCriteria)));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid node criteria: " + exporterNodeCriteria);
            }
        }
        return filters;
    }

    private static TimeRangeFilter getRequiredTimeRangeFilter(Collection<Filter> filters) {
        Optional<TimeRangeFilter> filter = filters.stream().filter(f -> f instanceof TimeRangeFilter).map(f -> (TimeRangeFilter)f).findFirst();
        if (!filter.isPresent()) {
            throw new BadRequestException("Time range is required.");
        }
        return filter.get();
    }

    private static long getEffectiveStart(long start, long effectiveEnd) {
        long effectiveStart = start >= 0L ? start : effectiveEnd + start;
        effectiveStart = Math.max(effectiveStart, 0L);
        return effectiveStart;
    }

    private static long getEffectiveEnd(long end) {
        return end > 0L ? end : new Date().getTime();
    }

    private static <T> T waitForFuture(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new WebApplicationException("Failed to execute query: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void populateResponseFromTable(Table<?, Long, Double> table, FlowSeriesResponse response) {
        List timestamps = table.columnKeySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        LinkedList values = new LinkedList();
        for (Object rowKey : table.rowKeySet()) {
            ArrayList<Double> column = new ArrayList<Double>(timestamps.size());
            for (Long ts : timestamps) {
                Double val = (Double)table.get(rowKey, (Object)ts);
                if (val == null) {
                    val = Double.NaN;
                }
                column.add(val);
            }
            values.add(column);
        }
        response.setTimestamps(timestamps);
        response.setValues(values);
    }

    public FlowGraphUrlInfo getFlowGraphUrlInfo(UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)this.flowGraphUrl)) {
            return null;
        }
        long flowCount = (Long)FlowRestServiceImpl.waitForFuture(this.flowRepository.getFlowCount(FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters())));
        FlowGraphUrlInfo graphUrlInfo = new FlowGraphUrlInfo();
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        String flowUrl = this.getFlowGraphUrl();
        String formattedGraphUrl = flowUrl.replaceAll("\\$nodeId", (String)queryParams.getFirst((Object)"exporterNode")).replaceAll("\\$ifIndex", (String)queryParams.getFirst((Object)"ifIndex")).replaceAll("\\$start", (String)queryParams.getFirst((Object)"start")).replaceAll("\\$end", (String)queryParams.getFirst((Object)"end"));
        graphUrlInfo.setFlowGraphUrl(formattedGraphUrl);
        graphUrlInfo.setFlowCount(flowCount);
        return graphUrlInfo;
    }

    public String getFlowGraphUrl() {
        return this.flowGraphUrl;
    }

    public void setFlowGraphUrl(String flowGraphUrl) {
        this.flowGraphUrl = flowGraphUrl;
    }
}

