/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.common.collect.Table;
import io.searchbox.client.JestClient;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.opennms.features.jest.client.ConnectionPoolShutdownException;
import org.opennms.features.jest.client.template.IndexSettings;
import org.opennms.netmgt.flows.api.Conversation;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.api.FlowException;
import org.opennms.netmgt.flows.api.FlowRepository;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.flows.api.Host;
import org.opennms.netmgt.flows.api.TrafficSummary;
import org.opennms.netmgt.flows.api.UnrecoverableFlowException;
import org.opennms.netmgt.flows.elastic.ElasticFlowRepositoryInitializer;
import org.opennms.netmgt.flows.filter.api.Filter;
import org.osgi.framework.BundleContext;

public class InitializingFlowRepository
implements FlowRepository {
    private final ElasticFlowRepositoryInitializer initializer;
    private final FlowRepository delegate;

    public InitializingFlowRepository(BundleContext bundleContext, FlowRepository delegate, JestClient client, IndexSettings indexSettings) {
        this(delegate, new ElasticFlowRepositoryInitializer(bundleContext, client, indexSettings));
    }

    protected InitializingFlowRepository(FlowRepository delegate, JestClient client) {
        this(delegate, new ElasticFlowRepositoryInitializer(client));
    }

    private InitializingFlowRepository(FlowRepository delegate, ElasticFlowRepositoryInitializer initializer) {
        this.delegate = Objects.requireNonNull(delegate);
        this.initializer = Objects.requireNonNull(initializer);
    }

    public void persist(Collection<Flow> flows, FlowSource source) throws FlowException {
        try {
            this.ensureInitialized();
            this.delegate.persist(flows, source);
        }
        catch (ConnectionPoolShutdownException ex) {
            throw new UnrecoverableFlowException(ex.getMessage(), (Throwable)ex);
        }
    }

    public CompletableFuture<Long> getFlowCount(List<Filter> filters) {
        return this.delegate.getFlowCount(filters);
    }

    public CompletableFuture<List<String>> getApplications(String matchingPrefix, long limit, List<Filter> filters) {
        return this.delegate.getApplications(matchingPrefix, limit, filters);
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getApplicationSeries(Set<String> applications, long step, boolean includeOther, List<Filter> filters) {
        return this.delegate.getApplicationSeries(applications, step, includeOther, filters);
    }

    public CompletableFuture<List<TrafficSummary<String>>> getTopNApplicationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.delegate.getTopNApplicationSummaries(N, includeOther, filters);
    }

    public CompletableFuture<List<TrafficSummary<String>>> getApplicationSummaries(Set<String> applications, boolean includeOther, List<Filter> filters) {
        return this.delegate.getApplicationSummaries(applications, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getTopNApplicationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.delegate.getTopNApplicationSeries(N, step, includeOther, filters);
    }

    public CompletableFuture<List<String>> getConversations(String locationPattern, String protocolPattern, String lowerIPPattern, String upperIPPattern, String applicationPattern, long limit, List<Filter> filters) {
        return this.delegate.getConversations(locationPattern, protocolPattern, lowerIPPattern, upperIPPattern, applicationPattern, limit, filters);
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getTopNConversationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.delegate.getTopNConversationSummaries(N, includeOther, filters);
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getConversationSummaries(Set<String> conversations, boolean includeOther, List<Filter> filters) {
        return this.delegate.getConversationSummaries(conversations, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getConversationSeries(Set<String> conversations, long step, boolean includeOther, List<Filter> filters) {
        return this.delegate.getConversationSeries(conversations, step, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getTopNConversationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.delegate.getTopNConversationSeries(N, step, includeOther, filters);
    }

    public CompletableFuture<List<String>> getHosts(String regex, long limit, List<Filter> filters) {
        return this.delegate.getHosts(regex, limit, filters);
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getTopNHostSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.delegate.getTopNHostSummaries(N, includeOther, filters);
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getHostSummaries(Set<String> hosts, boolean includeOther, List<Filter> filters) {
        return this.delegate.getHostSummaries(hosts, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getHostSeries(Set<String> hosts, long step, boolean includeOther, List<Filter> filters) {
        return this.delegate.getHostSeries(hosts, step, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getTopNHostSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.delegate.getTopNHostSeries(N, step, includeOther, filters);
    }

    private void ensureInitialized() {
        if (!this.initializer.isInitialized()) {
            this.initializer.initialize();
        }
    }
}

