/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import org.opennms.netmgt.flows.api.Flow;

public enum SamplingAlgorithm {
    Unassigned,
    SystematicCountBasedSampling,
    SystematicTimeBasedSampling,
    RandomNoutOfNSampling,
    UniformProbabilisticSampling,
    PropertyMatchFiltering,
    HashBasedFiltering,
    FlowStateDependentIntermediateFlowSelectionProcess;


    public static SamplingAlgorithm from(Flow.SamplingAlgorithm samplingAlgorithm) {
        if (samplingAlgorithm == null) {
            return Unassigned;
        }
        switch (samplingAlgorithm) {
            case Unassigned: {
                return Unassigned;
            }
            case SystematicCountBasedSampling: {
                return SystematicCountBasedSampling;
            }
            case SystematicTimeBasedSampling: {
                return SystematicTimeBasedSampling;
            }
            case RandomNoutOfNSampling: {
                return RandomNoutOfNSampling;
            }
            case UniformProbabilisticSampling: {
                return UniformProbabilisticSampling;
            }
            case PropertyMatchFiltering: {
                return PropertyMatchFiltering;
            }
            case HashBasedFiltering: {
                return HashBasedFiltering;
            }
            case FlowStateDependentIntermediateFlowSelectionProcess: {
                return FlowStateDependentIntermediateFlowSelectionProcess;
            }
        }
        throw new IllegalArgumentException("Unknown sampling algorithm: " + samplingAlgorithm.name());
    }
}

