/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.common.collect.ImmutableMap;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.flows.filter.api.ExporterNodeFilter;
import org.opennms.netmgt.flows.filter.api.Filter;
import org.opennms.netmgt.flows.filter.api.FilterVisitor;
import org.opennms.netmgt.flows.filter.api.SnmpInterfaceIdFilter;
import org.opennms.netmgt.flows.filter.api.TimeRangeFilter;

public class SearchQueryProvider
implements FilterVisitor<String> {
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);

    public SearchQueryProvider() {
        this.cfg.setClassForTemplateLoading(this.getClass(), "");
        this.cfg.setDefaultEncoding(StandardCharsets.UTF_8.name());
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }

    public String getFlowCountQuery(List<Filter> filters) {
        return this.render("flow_count.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).build());
    }

    public String getUniqueNodeExporters(long size, List<Filter> filters) {
        return this.render("unique_node_exporters.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"size", (Object)size).build());
    }

    public String getUniqueSnmpInterfaces(long size, List<Filter> filters) {
        return this.render("unique_snmp_interfaces.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"size", (Object)size).build());
    }

    public String getTopNQuery(int N, String groupByTerm, String keyForMissingTerm, List<Filter> filters) {
        return this.render("top_n_terms.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"N", (Object)N).put((Object)"groupByTerm", (Object)groupByTerm).put((Object)"keyForMissingTerm", (Object)(keyForMissingTerm != null ? keyForMissingTerm : "")).build());
    }

    public String getSeriesFromQuery(Collection<String> from, long step, long start, long end, String groupByTerm, List<Filter> filters) {
        return this.render("series_for_terms.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"from", from).put((Object)"groupByTerm", (Object)groupByTerm).put((Object)"step", (Object)step).put((Object)"start", (Object)start).put((Object)"end", (Object)end).build());
    }

    public String getSeriesFromMissingQuery(long step, long start, long end, String groupByTerm, String keyForMissingTerm, List<Filter> filters) {
        return this.render("series_for_missing.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"groupByTerm", (Object)groupByTerm).put((Object)"keyForMissingTerm", (Object)keyForMissingTerm).put((Object)"step", (Object)step).put((Object)"start", (Object)start).put((Object)"end", (Object)end).build());
    }

    public String getSeriesFromOthersQuery(Collection<String> from, long step, long start, long end, String groupByTerm, boolean excludeMissing, List<Filter> filters) {
        return this.render("series_for_others.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"from", from).put((Object)"groupByTerm", (Object)groupByTerm).put((Object)"excludeMissing", (Object)excludeMissing).put((Object)"step", (Object)step).put((Object)"start", (Object)start).put((Object)"end", (Object)end).build());
    }

    public String getApplicationsQuery(String prefix, long limit, List<Filter> filters) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(filters);
        return this.render("aggregate_by_fuzzed_field.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"N", (Object)limit).put((Object)"field", (Object)"netflow.application").put((Object)"prefix", (Object)prefix).build());
    }

    public String getHostsQuery(String regex, long limit, List<Filter> filters) {
        Objects.requireNonNull(filters);
        return this.render("aggregate_by_regex.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"regex", (Object)regex).put((Object)"limit", (Object)limit).put((Object)"field", (Object)"hosts").build());
    }

    public String getConversationsRegexQuery(String regex, long limit, List<Filter> filters) {
        Objects.requireNonNull(filters);
        return this.render("aggregate_by_regex.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"regex", (Object)regex).put((Object)"limit", (Object)limit).put((Object)"field", (Object)"netflow.convo_key").build());
    }

    private String render(String templateName, Map<Object, Object> context) {
        try {
            StringWriter writer = new StringWriter();
            Template template = this.cfg.getTemplate(templateName);
            template.process(context, (Writer)writer);
            return writer.toString();
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getFilterQueries(List<Filter> filters) {
        return filters.stream().map(f -> (String)f.visit((FilterVisitor)this)).collect(Collectors.toList());
    }

    public String visit(ExporterNodeFilter exporterNodeFilter) {
        return this.render("filter_exporter_node.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"nodeCriteria", (Object)exporterNodeFilter.getCriteria()).build());
    }

    public String visit(TimeRangeFilter timeRangeFilter) {
        return this.render("filter_time_range.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"start", (Object)timeRangeFilter.getStart()).put((Object)"end", (Object)timeRangeFilter.getEnd()).build());
    }

    public String visit(SnmpInterfaceIdFilter snmpInterfaceIdFilter) {
        return this.render("filter_snmp_interface.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"snmpInterfaceId", (Object)snmpInterfaceIdFilter.getSnmpInterfaceId()).build());
    }

    public String getHostnameByConversationQuery(String convoKey, List<Filter> filters) {
        return this.render("hostname_by_convo.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"convoKey", (Object)convoKey).build());
    }

    public String getHostnameByHostQuery(String host, List<Filter> filters) {
        return this.render("hostname_by_host.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"filters", this.getFilterQueries(filters)).put((Object)"host", (Object)host).build());
    }
}

