/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.TrafficSummary;

public class BytesInOut
implements Comparable<BytesInOut> {
    private long bytesIn;
    private long bytesOut;

    public BytesInOut() {
        this(0L, 0L);
    }

    public BytesInOut(long bytesIn, long bytesOut) {
        this.bytesIn = bytesIn;
        this.bytesOut = bytesOut;
    }

    public static BytesInOut sum(BytesInOut a, BytesInOut b) {
        return new BytesInOut(a.bytesIn + b.bytesIn, a.bytesOut + b.bytesOut);
    }

    public static <T> BytesInOut sum(List<TrafficSummary<T>> summaries) {
        BytesInOut bytes = new BytesInOut();
        for (TrafficSummary<T> summary : summaries) {
            bytes.bytesIn += summary.getBytesIn();
            bytes.bytesOut += summary.getBytesOut();
        }
        return bytes;
    }

    public BytesInOut minus(BytesInOut other) {
        return new BytesInOut(Math.max(this.bytesIn - other.bytesIn, 0L), Math.max(this.bytesOut - other.bytesOut, 0L));
    }

    public static <T> BytesInOut sum(ImmutableSet<Map.Entry<Directional<T>, Double>> entrySet) {
        BytesInOut bytes = new BytesInOut();
        for (Map.Entry entry : entrySet) {
            if (((Directional)entry.getKey()).isIngress()) {
                bytes.bytesIn = (long)((double)bytes.bytesIn + (Double)entry.getValue());
                continue;
            }
            bytes.bytesOut = (long)((double)bytes.bytesOut + (Double)entry.getValue());
        }
        return bytes;
    }

    public long getBytesIn() {
        return this.bytesIn;
    }

    public long getBytesOut() {
        return this.bytesOut;
    }

    @Override
    public int compareTo(BytesInOut other) {
        return Long.compare(this.bytesIn + this.bytesOut, other.bytesIn + other.bytesOut);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytesInOut)) {
            return false;
        }
        BytesInOut flowBytes = (BytesInOut)o;
        return this.bytesIn == flowBytes.bytesIn && this.bytesOut == flowBytes.bytesOut;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bytesIn", this.bytesIn).add("bytesOut", this.bytesOut).toString();
    }
}

