/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.opennms.netmgt.flows.api.BytesInOut;

public class TrafficSummary<T> {
    private final T entity;
    private final long bytesIn;
    private final long bytesOut;

    public TrafficSummary(Builder<T> builder) {
        this.entity = Objects.requireNonNull(((Builder)builder).entity);
        this.bytesIn = ((Builder)builder).bytesIn;
        this.bytesOut = ((Builder)builder).bytesOut;
    }

    public T getEntity() {
        return this.entity;
    }

    public long getBytesIn() {
        return this.bytesIn;
    }

    public long getBytesOut() {
        return this.bytesOut;
    }

    public BytesInOut getBytesInOut() {
        return new BytesInOut(this.bytesIn, this.bytesOut);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> from(T entity) {
        return new Builder<T>().withEntity(entity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrafficSummary)) {
            return false;
        }
        TrafficSummary that = (TrafficSummary)o;
        return this.bytesIn == that.bytesIn && this.bytesOut == that.bytesOut && Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.bytesIn, this.bytesOut);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entity", this.entity).add("bytesIn", this.bytesIn).add("bytesOut", this.bytesOut).toString();
    }

    public static class Builder<T> {
        private T entity;
        private long bytesIn;
        private long bytesOut;

        private Builder() {
        }

        public Builder<T> withEntity(T entity) {
            this.entity = Objects.requireNonNull(entity);
            return this;
        }

        public Builder<T> withBytesIn(long bytesIn) {
            this.bytesIn = bytesIn;
            return this;
        }

        public Builder<T> withBytesOut(long bytesOut) {
            this.bytesOut = bytesOut;
            return this;
        }

        public Builder<T> withBytes(long bytesIn, long bytesOut) {
            return this.withBytesIn(bytesIn).withBytesOut(bytesOut);
        }

        public Builder<T> withBytesFrom(TrafficSummary<?> source) {
            Objects.requireNonNull(source);
            this.bytesIn = source.getBytesIn();
            this.bytesOut = source.getBytesOut();
            return this;
        }

        public TrafficSummary<T> build() {
            return new TrafficSummary(this);
        }
    }
}

