/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.filter.api;

import java.util.Objects;

public class NodeCriteria {
    private final String foreignSource;
    private final String foreignId;
    private final Integer nodeId;

    public NodeCriteria(String criteria) {
        String[] tokens = criteria.split(":");
        if (tokens.length == 1) {
            this.nodeId = Integer.parseInt(tokens[0]);
            this.foreignSource = null;
            this.foreignId = null;
        } else if (tokens.length == 2) {
            this.foreignSource = tokens[0];
            this.foreignId = tokens[1];
            this.nodeId = null;
        } else {
            throw new IllegalArgumentException("Invalid node criteria " + criteria);
        }
    }

    public NodeCriteria(String foreignSource, String foreignId) {
        this.foreignSource = Objects.requireNonNull(foreignSource);
        this.foreignId = Objects.requireNonNull(foreignId);
        this.nodeId = null;
    }

    public NodeCriteria(Integer nodeId) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.foreignSource = null;
        this.foreignId = null;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String getCriteria() {
        return NodeCriteria.toCriteria(this.nodeId, this.foreignId, this.foreignSource);
    }

    public static String toCriteria(int id, String foreignId, String foreignSource) {
        if (foreignId != null && foreignSource != null) {
            return String.format("%s:%s", foreignSource, foreignId);
        }
        return Integer.toString(id);
    }

    public String toString() {
        return String.format("NodeCriteria[%s]", this.getCriteria());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeCriteria that = (NodeCriteria)o;
        return Objects.equals(this.foreignSource, that.foreignSource) && Objects.equals(this.foreignId, that.foreignId) && Objects.equals(this.nodeId, that.nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.foreignSource, this.foreignId, this.nodeId);
    }
}

