/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.api;

import java.util.Optional;

public interface Flow {
    public static final int IPV4_PROTOCOL_VERSION = 4;
    public static final int IPV6_PROTOCOL_VERSION = 6;

    public long getTimestamp();

    public Long getBytes();

    public Direction getDirection();

    public String getDstAddr();

    public Optional<String> getDstAddrHostname();

    public Integer getDstAs();

    public Integer getDstMaskLen();

    public Integer getDstPort();

    public Integer getEngineId();

    public Integer getEngineType();

    public Long getFirstSwitched();

    public int getFlowRecords();

    public long getFlowSeqNum();

    public Integer getInputSnmp();

    public Integer getIpProtocolVersion();

    public Long getLastSwitched();

    public String getNextHop();

    public Optional<String> getNextHopHostname();

    public Integer getOutputSnmp();

    public Long getPackets();

    public Integer getProtocol();

    public SamplingAlgorithm getSamplingAlgorithm();

    public Double getSamplingInterval();

    public String getSrcAddr();

    public Optional<String> getSrcAddrHostname();

    public Integer getSrcAs();

    public Integer getSrcMaskLen();

    public Integer getSrcPort();

    public Integer getTcpFlags();

    public Integer getTos();

    public NetflowVersion getNetflowVersion();

    public Integer getVlan();

    public static enum SamplingAlgorithm {
        Unassigned,
        SystematicCountBasedSampling,
        SystematicTimeBasedSampling,
        RandomNoutOfNSampling,
        UniformProbabilisticSampling,
        PropertyMatchFiltering,
        HashBasedFiltering,
        FlowStateDependentIntermediateFlowSelectionProcess;

    }

    public static enum Direction {
        INGRESS,
        EGRESS;

    }

    public static enum NetflowVersion {
        V5,
        V9,
        IPFIX,
        SFLOW;

    }
}

