/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.persistence.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.classification.persistence.api.RulePositionComparator;

@Table(name="classification_groups")
@Entity
public class Group {
    @Id
    @SequenceGenerator(name="ruleSequence", sequenceName="ruleNxtId")
    @GeneratedValue(generator="ruleSequence")
    private Integer id;
    @Column(name="name", nullable=false, unique=true)
    private String name;
    @Column(name="readonly")
    private boolean readOnly = false;
    @Column(name="enabled")
    private boolean enabled = true;
    @Column(name="position", nullable=false)
    private int position;
    @Column(name="description")
    private String description;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="group", orphanRemoval=true)
    private List<Rule> rules = new ArrayList<Rule>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Rule> getRules() {
        this.rules.sort(new RulePositionComparator());
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public void addRule(Rule rule) {
        Objects.requireNonNull(rule);
        if (!this.rules.contains(rule)) {
            this.rules.add(rule);
            rule.setGroup(this);
        }
    }

    public void removeRule(Rule rule) {
        this.rules.remove(rule);
        rule.setGroup(null);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "Group{id=" + this.id + ", name='" + this.name + '\'' + ", readOnly=" + this.readOnly + ", enabled=" + this.enabled + ", position=" + this.position + ", description='" + this.description + '\'' + '}';
    }
}

