/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.events.sink.dispatcher;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;

@Command(scope="opennms", name="send-event", description="Send event with specified uei and params")
@Service
public class EventSendCommand
implements Action {
    @Reference
    private EventForwarder eventForwarder;
    @Option(name="-u", aliases={"--uei"}, description="events uei", required=true, multiValued=false)
    String eventUei;
    @Argument(index=0, name="parameters", description="Parameters in key=value form", multiValued=true)
    List<String> params;

    public Object execute() throws Exception {
        if (this.eventUei == null) {
            System.out.println("Event uei need to specified with -u or --uei option");
        }
        EventBuilder eventBuilder = new EventBuilder(this.eventUei, "karaf-shell");
        Map<String, String> parameters = EventSendCommand.parse(this.params);
        parameters.forEach((arg_0, arg_1) -> ((EventBuilder)eventBuilder).addParam(arg_0, arg_1));
        this.eventForwarder.sendNow(eventBuilder.getEvent());
        System.out.printf("Event with uei '%s' is being sent asynchronously \n ", this.eventUei);
        return null;
    }

    private static Map<String, String> parse(List<String> params) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (params != null) {
            for (String keyValue : params) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid param " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                properties.put(key, value);
            }
        }
        return properties;
    }
}

