/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.daemon.DaemonTools;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.trapd.TrapListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="trapd", logPrefix="trapd")
public class Trapd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Trapd.class);
    public static final String LOG4J_CATEGORY = "trapd";
    private int m_status = 0;
    @Autowired
    private TrapListener m_trapListener;

    public Trapd() {
        super(LOG4J_CATEGORY);
    }

    protected synchronized void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
    }

    protected synchronized void onStart() {
        this.m_status = 1;
        LOG.debug("start: Initializing the Trapd receiver");
        this.m_trapListener.start();
        this.m_status = 2;
        LOG.debug("start: Trapd is ready to receive traps");
    }

    protected void onPause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        LOG.debug("pause: Calling pause on trap receiver");
        this.m_trapListener.stop();
        this.m_status = 6;
        LOG.debug("pause: Trapd paused");
    }

    protected void onResume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        LOG.debug("resume: Calling resume on trap receiver");
        this.m_trapListener.start();
        this.m_status = 2;
        LOG.debug("resume: Trapd resumed");
    }

    protected synchronized void onStop() {
        this.m_status = 3;
        LOG.debug("stop: Closing communication paths");
        this.m_trapListener.stop();
        this.m_status = 4;
        LOG.debug("stop: Trapd stopped");
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadEvent(Event e) {
        DaemonTools.handleReloadEvent((Event)e, (String)LOG4J_CATEGORY, event -> this.handleConfigurationChanged());
    }

    private void handleConfigurationChanged() {
        this.stop();
        try {
            this.m_trapListener.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.start();
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }
}

