/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.trapd.TrapListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class Trapd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Trapd.class);
    public static final String LOG4J_CATEGORY = "trapd";
    private int m_status = 0;
    @Autowired
    private TrapListener m_trapListener;

    public Trapd() {
        super(LOG4J_CATEGORY);
    }

    protected synchronized void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
    }

    protected synchronized void onStart() {
        this.m_status = 1;
        LOG.debug("start: Initializing the Trapd receiver");
        this.m_trapListener.start();
        this.m_status = 2;
        LOG.debug("start: Trapd is ready to receive traps");
    }

    protected void onPause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        LOG.debug("pause: Calling pause on trap receiver");
        this.m_trapListener.stop();
        this.m_status = 6;
        LOG.debug("pause: Trapd paused");
    }

    protected void onResume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        LOG.debug("resume: Calling resume on trap receiver");
        this.m_trapListener.start();
        this.m_status = 2;
        LOG.debug("resume: Trapd resumed");
    }

    protected synchronized void onStop() {
        this.m_status = 3;
        LOG.debug("stop: Closing communication paths");
        this.m_trapListener.stop();
        this.m_status = 4;
        LOG.debug("stop: Trapd stopped");
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }
}

