/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.Date;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.snmp.SyntaxToEvent;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.trapd.TrapDTO;
import org.opennms.netmgt.trapd.TrapIdentityDTO;
import org.opennms.netmgt.xml.eventconf.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventCreator {
    private static final Logger LOG = LoggerFactory.getLogger(EventCreator.class);
    private final InterfaceToNodeCache cache;
    private final EventConfDao eventConfDao;

    public EventCreator(InterfaceToNodeCache cache, EventConfDao eventConfDao) {
        this.cache = Objects.requireNonNull(cache);
        this.eventConfDao = Objects.requireNonNull(eventConfDao);
    }

    public org.opennms.netmgt.xml.event.Event createEventFrom(TrapDTO trapDTO, String systemId, String location, InetAddress trapAddress) {
        org.opennms.netmgt.xml.event.Event event;
        Event econf;
        LOG.debug("{} trap - trapInterface: {}", (Object)trapDTO.getVersion(), (Object)trapDTO.getAgentAddress());
        EventBuilder eventBuilder = new EventBuilder(null, "trapd");
        eventBuilder.setTime(new Date(trapDTO.getCreationTime()));
        eventBuilder.setCommunity(trapDTO.getCommunity());
        eventBuilder.setSnmpTimeStamp(trapDTO.getTimestamp());
        eventBuilder.setSnmpVersion(trapDTO.getVersion());
        eventBuilder.setSnmpHost(InetAddressUtils.str((InetAddress)trapAddress));
        eventBuilder.setInterface(trapAddress);
        eventBuilder.setHost(InetAddressUtils.toIpAddrString((InetAddress)trapDTO.getAgentAddress()));
        TrapIdentityDTO trapIdentity = trapDTO.getTrapIdentity();
        if (trapIdentity != null) {
            LOG.debug("Trap Identity {}", (Object)trapIdentity);
            eventBuilder.setGeneric(trapIdentity.getGeneric());
            eventBuilder.setSpecific(trapIdentity.getSpecific());
            eventBuilder.setEnterpriseId(trapIdentity.getEnterpriseId());
        }
        for (SnmpResult eachResult : trapDTO.getResults()) {
            SnmpObjId name = eachResult.getBase();
            SnmpValue value = eachResult.getValue();
            eventBuilder.addParam(SyntaxToEvent.processSyntax((String)name.toString(), (SnmpValue)value));
            if (!EventConstants.OID_SNMP_IFINDEX.isPrefixOf(name)) continue;
            eventBuilder.setIfIndex(value.toInt());
        }
        long nodeId = this.resolveNodeId(location, trapAddress);
        if (nodeId != -1L) {
            eventBuilder.setNodeid(nodeId);
        }
        if (systemId != null) {
            eventBuilder.setDistPoller(systemId);
        }
        if ((econf = this.eventConfDao.findByEvent(event = eventBuilder.getEvent())) == null || econf.getUei() == null) {
            event.setUei("uei.opennms.org/default/trap");
        } else {
            event.setUei(econf.getUei());
        }
        return event;
    }

    private long resolveNodeId(String location, InetAddress trapAddress) {
        if (location == null) {
            return this.cache.getNodeId("Default", trapAddress);
        }
        return this.cache.getNodeId(location, trapAddress);
    }
}

