/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.opennms.core.concurrent.ExecutorFactory;
import org.opennms.core.concurrent.ExecutorFactoryJavaImpl;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.trapd.TrapNotificationHandler;
import org.opennms.netmgt.trapd.TrapQueueProcessor;
import org.opennms.netmgt.trapd.TrapQueueProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapNotificationHandlerDefaultImpl
implements TrapNotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TrapNotificationHandlerDefaultImpl.class);
    public static final int TRAP_PROCESSOR_THREADS = Runtime.getRuntime().availableProcessors();
    public static final int QUEUE_SIZE = 25000;
    private final ExecutorFactory m_executorFactory = new ExecutorFactoryJavaImpl();
    private final ExecutorService m_processorExecutor = this.m_executorFactory.newExecutor(TRAP_PROCESSOR_THREADS, 25000, "OpenNMS.Trapd", "trapProcessors");
    private TrapQueueProcessorFactory m_processorFactory;
    private InterfaceToNodeCache m_cache;

    @Override
    public void handleTrapNotification(TrapNotification message) {
        try {
            message.setTrapProcessor((TrapProcessor)new EventCreator(this.m_cache));
            TrapQueueProcessor processor = this.m_processorFactory.getInstance(message);
            CompletableFuture.supplyAsync(processor::call, this.m_processorExecutor);
        }
        catch (Throwable e) {
            LOG.error("Task execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public TrapQueueProcessorFactory getProcessorFactory() {
        return this.m_processorFactory;
    }

    public void setProcessorFactory(TrapQueueProcessorFactory m_processorFactory) {
        this.m_processorFactory = m_processorFactory;
    }

    public InterfaceToNodeCache getInterfaceToNodeCache() {
        return this.m_cache;
    }

    public void setInterfaceToNodeCache(InterfaceToNodeCache cache) {
        this.m_cache = cache;
    }
}

