/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.snmp.BasicTrapProcessor;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TrapInformation;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JTrapNotifier;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JUtils;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValue;
import org.opennms.netmgt.trapd.TrapDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class TrapObjectToDTOProcessor
implements Processor {
    public static final Logger LOG = LoggerFactory.getLogger(TrapObjectToDTOProcessor.class);
    private DistPollerDao m_distPollerDao;
    private static final String SNMP_V1 = "v1";
    private static final String SNMP_V2 = "v2";
    private static final String SNMP_V3 = "v3";
    public static final String INCLUDE_RAW_MESSAGE = "includeRawMessage";
    public static final boolean INCLUDE_RAW_MESSAGE_DEFAULT = Boolean.FALSE;

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    public void process(Exchange exchange) throws Exception {
        TrapInformation object = (TrapInformation)exchange.getIn().getBody(TrapInformation.class);
        boolean trapRawMessageFlag = (Boolean)exchange.getIn().getHeader(INCLUDE_RAW_MESSAGE);
        exchange.getIn().setBody((Object)this.object2dto(object, trapRawMessageFlag), TrapDTO.class);
    }

    public TrapDTO object2dto(TrapInformation trapInfo) {
        return this.object2dto(trapInfo, INCLUDE_RAW_MESSAGE_DEFAULT);
    }

    public TrapDTO object2dto(TrapInformation trapInfo, boolean trapRawMessageFlag) {
        TrapDTO trapDTO = new TrapDTO();
        String version = trapInfo.getVersion();
        String id = this.m_distPollerDao.whoami().getId();
        String location = this.m_distPollerDao.whoami().getLocation();
        if (version.equalsIgnoreCase(SNMP_V1)) {
            Snmp4JTrapNotifier.Snmp4JV1TrapInformation v1Trap = (Snmp4JTrapNotifier.Snmp4JV1TrapInformation)trapInfo;
            String community = v1Trap.getCommunity();
            InetAddress trapAddress = v1Trap.getTrapAddress();
            PDUv1 pdu = v1Trap.getPdu();
            if (trapRawMessageFlag) {
                try {
                    byte[] byteArray = Snmp4JUtils.convertPduToBytes((InetAddress)trapAddress, (int)0, (String)community, (PDU)pdu);
                    trapDTO.setBody(byteArray);
                }
                catch (Throwable e) {
                    LOG.warn("Unable to convert PDU into bytes: {}", (Object)e.getMessage());
                }
            }
            trapDTO.setAgentAddress(v1Trap.getAgentAddress());
            trapDTO.setCommunity(community);
            trapDTO.setCreationTime(v1Trap.getCreationTime());
            trapDTO.setLocation(location);
            trapDTO.setPduLength(v1Trap.getPduLength());
            trapDTO.setSourceAddress(trapAddress);
            trapDTO.setSystemId(id);
            trapDTO.setTimestamp(v1Trap.getTimeStamp());
            trapDTO.setVersion(version);
            trapDTO.setEnterpriseId(pdu.getEnterprise());
            trapDTO.setGeneric(pdu.getGenericTrap());
            trapDTO.setSpecific(pdu.getSpecificTrap());
            ArrayList<SnmpResult> results = new ArrayList<SnmpResult>();
            for (VariableBinding varBind : pdu.getVariableBindings()) {
                SnmpObjId oid = SnmpObjId.get((String)varBind.getOid().toString());
                Snmp4JValue value = new Snmp4JValue(varBind.getVariable());
                SnmpResult snmpResult = new SnmpResult(oid, null, (SnmpValue)value);
                results.add(snmpResult);
            }
            trapDTO.setResults(results);
        } else if (version.equalsIgnoreCase(SNMP_V2) || version.equalsIgnoreCase(SNMP_V3)) {
            Snmp4JTrapNotifier.Snmp4JV2TrapInformation v2Trap = (Snmp4JTrapNotifier.Snmp4JV2TrapInformation)trapInfo;
            String community = v2Trap.getCommunity();
            InetAddress trapAddress = v2Trap.getTrapAddress();
            PDU pdu = v2Trap.getPdu();
            if (trapRawMessageFlag) {
                try {
                    byte[] byteArray = Snmp4JUtils.convertPduToBytes((InetAddress)trapAddress, (int)0, (String)community, (PDU)pdu);
                    trapDTO.setBody(byteArray);
                }
                catch (Throwable e) {
                    LOG.warn("Unable to convert PDU into bytes: {}", (Object)e.getMessage());
                }
            }
            trapDTO.setAgentAddress(v2Trap.getAgentAddress());
            trapDTO.setCommunity(community);
            trapDTO.setCreationTime(v2Trap.getCreationTime());
            trapDTO.setLocation(location);
            trapDTO.setPduLength(v2Trap.getPduLength());
            trapDTO.setSourceAddress(trapAddress);
            trapDTO.setSystemId(id);
            trapDTO.setTimestamp(v2Trap.getTimeStamp());
            trapDTO.setVersion(version);
            BasicTrapProcessor trapsProcessor = (BasicTrapProcessor)v2Trap.getTrapProcessor();
            trapDTO.setEnterpriseId(new OID(trapsProcessor.getTrapIdentity().getEnterpriseId()));
            trapDTO.setGeneric(trapsProcessor.getTrapIdentity().getGeneric());
            trapDTO.setSpecific(trapsProcessor.getTrapIdentity().getSpecific());
            ArrayList<SnmpResult> results = new ArrayList<SnmpResult>();
            for (VariableBinding varBind : pdu.getVariableBindings()) {
                SnmpObjId oid = SnmpObjId.get((String)varBind.getOid().toString());
                Snmp4JValue value = new Snmp4JValue(varBind.getVariable());
                SnmpResult snmpResult = new SnmpResult(oid, null, (SnmpValue)value);
                results.add(snmpResult);
            }
            trapDTO.setResults(results);
        }
        return trapDTO;
    }
}

