/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JTrapNotifier;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValue;
import org.opennms.netmgt.trapd.TrapDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class TrapDTOToObjectProcessor
implements Processor {
    public static final Logger LOG = LoggerFactory.getLogger(TrapDTOToObjectProcessor.class);
    private static final String SNMP_V1 = "v1";
    private static final String SNMP_V2 = "v2";
    private static final String SNMP_V3 = "v3";

    public void process(Exchange exchange) throws Exception {
        TrapDTO object = (TrapDTO)((Object)exchange.getIn().getBody(TrapDTO.class));
        exchange.getIn().setBody((Object)TrapDTOToObjectProcessor.dto2object(object), TrapNotification.class);
    }

    public static TrapNotification dto2object(TrapDTO trapDto) {
        if (SNMP_V1.equalsIgnoreCase(trapDto.getHeader("version"))) {
            PDUv1 pdu = new PDUv1();
            pdu.setType(-89);
            pdu.setAgentAddress(new IpAddress(trapDto.getHeader("sourceAddress")));
            pdu.setTimestamp(Long.parseLong(trapDto.getHeader("timestamp")));
            for (SnmpResult snmpResult : trapDto.getResults()) {
                int type = snmpResult.getValue().getType();
                byte[] value = snmpResult.getValue().getBytes();
                OID oid = new OID(snmpResult.getBase().toString());
                pdu.add(new VariableBinding(oid, ((Snmp4JValue)SnmpUtils.getValueFactory().getValue(type, value)).getVariable()));
            }
            Snmp4JTrapNotifier.Snmp4JV1TrapInformation retval = new Snmp4JTrapNotifier.Snmp4JV1TrapInformation(InetAddrUtils.addr((String)trapDto.getHeader("agentAddress")), trapDto.getHeader("community"), pdu, null);
            retval.setCreationTime(Long.parseLong(trapDto.getHeader("creationTime")));
            retval.setLocation(trapDto.getHeader("location"));
            retval.setSystemId(trapDto.getHeader("systemId"));
            return retval;
        }
        if (SNMP_V2.equalsIgnoreCase(trapDto.getHeader("version")) || SNMP_V3.equalsIgnoreCase(trapDto.getHeader("version"))) {
            PDU pdu = new PDU();
            pdu.setType(-89);
            for (SnmpResult snmpResult : trapDto.getResults()) {
                int type = snmpResult.getValue().getType();
                byte[] value = snmpResult.getValue().getBytes();
                OID oid = new OID(snmpResult.getBase().toString());
                pdu.add(new VariableBinding(oid, ((Snmp4JValue)SnmpUtils.getValueFactory().getValue(type, value)).getVariable()));
            }
            Snmp4JTrapNotifier.Snmp4JV2TrapInformation retval = new Snmp4JTrapNotifier.Snmp4JV2TrapInformation(InetAddrUtils.addr((String)trapDto.getHeader("sourceAddress")), trapDto.getHeader("community"), pdu, null);
            retval.setCreationTime(Long.parseLong(trapDto.getHeader("creationTime")));
            retval.setLocation(trapDto.getHeader("location"));
            retval.setSystemId(trapDto.getHeader("systemId"));
            return retval;
        }
        throw new IllegalArgumentException("Unrecognized trap version in DTO: " + trapDto.getHeader("version"));
    }
}

