/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.Date;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.snmp.SyntaxToEvent;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCreator
implements TrapProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(EventCreator.class);
    private final EventBuilder m_eventBuilder;
    private final InterfaceToNodeCache m_cache;
    private String m_systemId;
    private String m_location;
    private InetAddress m_trapAddress;

    public EventCreator(InterfaceToNodeCache cache) {
        this.m_cache = cache;
        this.m_eventBuilder = new EventBuilder(null, "trapd");
    }

    public void setSystemId(String systemId) {
        this.m_systemId = systemId;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public void setCommunity(String community) {
        this.m_eventBuilder.setCommunity(community);
    }

    public void setCreationTime(long creationTime) {
        this.m_eventBuilder.setTime(new Date(creationTime));
    }

    public void setTimeStamp(long timeStamp) {
        this.m_eventBuilder.setSnmpTimeStamp(timeStamp);
    }

    public void setVersion(String version) {
        this.m_eventBuilder.setSnmpVersion(version);
    }

    private void setGeneric(int generic) {
        this.m_eventBuilder.setGeneric(generic);
    }

    private void setSpecific(int specific) {
        this.m_eventBuilder.setSpecific(specific);
    }

    private void setEnterpriseId(String enterpriseId) {
        this.m_eventBuilder.setEnterpriseId(enterpriseId);
    }

    public void setAgentAddress(InetAddress agentAddress) {
        this.m_eventBuilder.setHost(InetAddressUtils.toIpAddrString((InetAddress)agentAddress));
    }

    public void processVarBind(SnmpObjId name, SnmpValue value) {
        this.m_eventBuilder.addParam(SyntaxToEvent.processSyntax((String)name.toString(), (SnmpValue)value));
        if (EventConstants.OID_SNMP_IFINDEX.isPrefixOf(name)) {
            this.m_eventBuilder.setIfIndex(value.toInt());
        }
    }

    public void setTrapAddress(InetAddress trapAddress) {
        this.m_eventBuilder.setSnmpHost(InetAddressUtils.str((InetAddress)trapAddress));
        this.m_eventBuilder.setInterface(trapAddress);
        this.m_trapAddress = trapAddress;
    }

    public void setTrapIdentity(TrapIdentity trapIdentity) {
        this.setGeneric(trapIdentity.getGeneric());
        this.setSpecific(trapIdentity.getSpecific());
        this.setEnterpriseId(trapIdentity.getEnterpriseId().toString());
        LOG.debug("setTrapIdentity: SNMP trap {}", (Object)trapIdentity);
    }

    public Event getEvent() {
        long nodeId = -1L;
        nodeId = this.m_location == null ? (long)this.m_cache.getNodeId("localhost", this.m_trapAddress) : (long)this.m_cache.getNodeId(this.m_location, this.m_trapAddress);
        if (this.m_systemId != null) {
            this.m_eventBuilder.setDistPoller(this.m_systemId);
        }
        if (nodeId != -1L) {
            this.m_eventBuilder.setNodeid(nodeId);
        }
        return this.m_eventBuilder.getEvent();
    }
}

