/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.concurrent.Callable;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.netmgt.xml.eventconf.Snmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

class TrapQueueProcessor
implements Callable<Callable<?>>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(TrapQueueProcessor.class);
    private static final String LOCALHOST_ADDRESS = InetAddressUtils.getLocalHostName();
    private Boolean m_newSuspect;
    private EventIpcManager m_eventMgr;
    private EventConfDao m_eventConfDao;
    private TrapNotification m_trapNotification;
    private static long s_v1TrapsReceived = 0L;
    private static long s_v2cTrapsReceived = 0L;
    private static long s_v3TrapsReceived = 0L;
    private static long s_trapsDiscarded = 0L;
    private static long s_trapsErrored = 0L;

    @Override
    public Callable<Void> call() {
        try {
            this.processTrapEvent(((EventCreator)this.m_trapNotification.getTrapProcessor()).getEvent());
        }
        catch (IllegalArgumentException e) {
            LOG.info(e.getMessage());
        }
        catch (Throwable e) {
            LOG.error("Unexpected error processing trap: {}", (Object)e, (Object)e);
            ++s_trapsErrored;
        }
        return null;
    }

    private void processTrapEvent(org.opennms.netmgt.xml.event.Event event) {
        InetAddress trapInterface = event.getInterfaceAddress();
        Event econf = this.m_eventConfDao.findByEvent(event);
        if (econf == null || econf.getUei() == null) {
            event.setUei("uei.opennms.org/default/trap");
        } else {
            event.setUei(econf.getUei());
        }
        if (econf != null) {
            String dest;
            Logmsg logmsg;
            Snmp snmp = econf.getSnmp();
            if (snmp != null) {
                if ("v1".equals(snmp.getVersion())) {
                    ++s_v1TrapsReceived;
                } else if ("v2c".equals(snmp.getVersion())) {
                    ++s_v2cTrapsReceived;
                } else if ("v3".equals(snmp.getVersion())) {
                    ++s_v3TrapsReceived;
                }
            }
            if ((logmsg = econf.getLogmsg()) != null && "discardtraps".equals(dest = logmsg.getDest())) {
                LOG.debug("Trap discarded due to matching event having logmsg dest == discardtraps");
                ++s_trapsDiscarded;
                return;
            }
        }
        this.m_eventMgr.sendNow(event);
        LOG.debug("Trap successfully converted and sent to eventd with UEI {}", (Object)event.getUei());
        if (!event.hasNodeid() && this.m_newSuspect.booleanValue()) {
            this.sendNewSuspectEvent(InetAddressUtils.str((InetAddress)trapInterface));
            LOG.debug("Sent newSuspectEvent for interface: {}", (Object)trapInterface);
        }
    }

    private void sendNewSuspectEvent(String trapInterface) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "trapd");
        bldr.setInterface(InetAddressUtils.addr((String)trapInterface));
        bldr.setHost(LOCALHOST_ADDRESS);
        this.m_eventMgr.sendNow(bldr.getEvent());
    }

    public EventConfDao getEventConfDao() {
        return this.m_eventConfDao;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public Boolean isNewSuspect() {
        return this.m_newSuspect;
    }

    public void setNewSuspect(Boolean newSuspect) {
        this.m_newSuspect = newSuspect;
    }

    public TrapNotification getTrapNotification() {
        return this.m_trapNotification;
    }

    public void setTrapNotification(TrapNotification info) {
        this.m_trapNotification = info;
    }

    public void afterPropertiesSet() throws IllegalStateException {
        Assert.state((this.m_eventConfDao != null ? 1 : 0) != 0, (String)"property eventConfDao must be set");
        Assert.state((this.m_eventMgr != null ? 1 : 0) != 0, (String)"property eventMgr must be set");
        Assert.state((this.m_newSuspect != null ? 1 : 0) != 0, (String)"property newSuspect must be set");
        Assert.state((this.m_trapNotification != null ? 1 : 0) != 0, (String)"property trapNotification must be set");
    }

    public static long getV1TrapsReceived() {
        return s_v1TrapsReceived;
    }

    public static long getV2cTrapsReceived() {
        return s_v2cTrapsReceived;
    }

    public static long getV3TrapsReceived() {
        return s_v3TrapsReceived;
    }

    public static long getTrapsDiscarded() {
        return s_trapsDiscarded;
    }

    public static long getTrapsErrored() {
        return s_trapsErrored;
    }
}

