/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.nio.ByteBuffer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserState
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(ParserState.class);
    private final ByteBuffer buffer;
    public final SyslogMessage message;

    public ParserState(ByteBuffer input) {
        this(input, new SyslogMessage());
    }

    public ParserState(ByteBuffer input, SyslogMessage message) {
        this.buffer = input;
        this.message = message;
    }

    public ByteBuffer getBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("message", (Object)this.message).toString();
    }

    public ParserState clone() {
        ParserState retval = new ParserState(this.buffer.duplicate(), this.message.clone());
        LOG.trace("ORIGINAL: {}", (Object)this);
        LOG.trace("CLONE   : {}", (Object)retval);
        return retval;
    }
}

