/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.List;
import java.util.function.BiConsumer;
import org.opennms.core.time.ZonedDateTimeBuilder;
import org.opennms.netmgt.syslogd.ParserStage;
import org.opennms.netmgt.syslogd.ParserStageSequenceBuilder;
import org.opennms.netmgt.syslogd.ParserState;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GrokParserStageSequenceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GrokParserStageSequenceBuilder.class);

    private static BiConsumer<ParserState, Integer> semanticIntegerToField(String semanticString) {
        SyslogSemanticType semanticType = null;
        try {
            semanticType = SyslogSemanticType.valueOf(semanticString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (semanticType == null) {
            return (s, v) -> s.message.setParam(semanticString, (Integer)v);
        }
        switch (semanticType) {
            case day: {
                return (s, v) -> s.message.setDayOfMonth((Integer)v);
            }
            case facilityPriority: {
                return (s, v) -> {
                    SyslogFacility facility = SyslogFacility.getFacilityForCode(v);
                    SyslogSeverity priority = SyslogSeverity.getSeverityForCode(v);
                    s.message.setFacility(facility);
                    s.message.setSeverity(priority);
                };
            }
            case hour: {
                return (s, v) -> s.message.setHourOfDay((Integer)v);
            }
            case minute: {
                return (s, v) -> s.message.setMinute((Integer)v);
            }
            case month: {
                return (s, v) -> s.message.setMonth((Integer)v);
            }
            case processId: {
                return (s, v) -> s.message.setProcessId(String.valueOf(v));
            }
            case second: {
                return (s, v) -> s.message.setSecond((Integer)v);
            }
            case secondFraction: {
                return (s, v) -> {
                    if (v >= 1000) {
                        s.message.setMillisecond(Math.round(v / 1000));
                    } else {
                        s.message.setMillisecond((Integer)v);
                    }
                };
            }
            case version: {
                return (s, v) -> s.message.setVersion((Integer)v);
            }
            case year: {
                return (s, v) -> s.message.setYear((Integer)v);
            }
        }
        throw new IllegalArgumentException(String.format("Semantic type %s does not have an integer value", semanticString));
    }

    private static BiConsumer<ParserState, String> semanticStringToField(String semanticString) {
        SyslogSemanticType semanticType = null;
        try {
            semanticType = SyslogSemanticType.valueOf(semanticString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (semanticType == null) {
            return (s, v) -> s.message.setParam(semanticString, (String)v);
        }
        switch (semanticType) {
            case hostname: {
                return (s, v) -> s.message.setHostName((String)v);
            }
            case message: {
                return (s, v) -> s.message.setMessage(v == null ? null : v.trim());
            }
            case messageId: {
                return (s, v) -> {
                    if (!"-".equals(v.trim())) {
                        s.message.setMessageID((String)v);
                    }
                };
            }
            case processId: {
                return (s, v) -> {
                    if (!"-".equals(v.trim())) {
                        s.message.setProcessId((String)v);
                    }
                };
            }
            case processName: {
                return (s, v) -> {
                    if (!"-".equals(v.trim())) {
                        s.message.setProcessName((String)v);
                    }
                };
            }
            case secondFraction: {
                return (s, v) -> {
                    switch (v.length()) {
                        case 1: {
                            s.message.setMillisecond(ParserStageSequenceBuilder.MatchInteger.trimAndConvert(v) * 100);
                            break;
                        }
                        case 2: {
                            s.message.setMillisecond(ParserStageSequenceBuilder.MatchInteger.trimAndConvert(v) * 10);
                            break;
                        }
                        case 3: {
                            s.message.setMillisecond(ParserStageSequenceBuilder.MatchInteger.trimAndConvert(v));
                            break;
                        }
                        case 4: {
                            s.message.setMillisecond(ParserStageSequenceBuilder.MatchInteger.trimAndConvert(v) / 10);
                            break;
                        }
                        case 5: {
                            s.message.setMillisecond(ParserStageSequenceBuilder.MatchInteger.trimAndConvert(v) / 100);
                            break;
                        }
                        case 6: {
                            s.message.setMillisecond(ParserStageSequenceBuilder.MatchInteger.trimAndConvert(v) / 1000);
                        }
                    }
                };
            }
            case timezone: {
                return (s, v) -> s.message.setZoneId(ZonedDateTimeBuilder.parseZoneId((String)v));
            }
        }
        throw new IllegalArgumentException(String.format("Semantic type %s does not have a string value", semanticString));
    }

    public static List<ParserStage> parseGrok(String grok) {
        GrokState state = GrokState.TEXT;
        ParserStageSequenceBuilder factory = new ParserStageSequenceBuilder();
        StringBuilder pattern = new StringBuilder();
        StringBuilder semantic = new StringBuilder();
        block57: for (char c : grok.toCharArray()) {
            switch (state) {
                case TEXT: {
                    switch (c) {
                        case '%': {
                            state = GrokState.START_PATTERN;
                            continue block57;
                        }
                        case '\\': {
                            state = GrokState.ESCAPE_PATTERN;
                            continue block57;
                        }
                        case ' ': {
                            factory = factory.whitespace();
                            continue block57;
                        }
                    }
                    factory = factory.character(c);
                    continue block57;
                }
                case ESCAPE_PATTERN: {
                    switch (c) {
                        default: 
                    }
                    factory = factory.character(c);
                    state = GrokState.TEXT;
                    continue block57;
                }
                case START_PATTERN: {
                    switch (c) {
                        case '{': {
                            state = GrokState.PATTERN;
                            continue block57;
                        }
                    }
                    throw new IllegalStateException("Illegal character to start pattern");
                }
                case PATTERN: {
                    switch (c) {
                        case ':': {
                            state = GrokState.SEMANTIC;
                            continue block57;
                        }
                    }
                    pattern.append(c);
                    continue block57;
                }
                case SEMANTIC: {
                    switch (c) {
                        case '}': {
                            state = GrokState.END_PATTERN;
                            continue block57;
                        }
                    }
                    semantic.append(c);
                    continue block57;
                }
                case END_PATTERN: {
                    String patternString = pattern.toString();
                    String semanticString = semantic.toString();
                    GrokPattern patternType = GrokPattern.valueOf(patternString);
                    block24 : switch (c) {
                        case '\\': {
                            switch (patternType) {
                                case NOSPACE: {
                                    throw new UnsupportedOperationException("Cannot support escape sequence directly after a NOSPACE pattern yet");
                                }
                                case STRING: {
                                    throw new UnsupportedOperationException("Cannot support escape sequence directly after a STRING pattern yet");
                                }
                                case INT: {
                                    factory.integer(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                                    break;
                                }
                                case MONTH: {
                                    factory.monthString(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                                }
                            }
                            pattern = new StringBuilder();
                            semantic = new StringBuilder();
                            state = GrokState.ESCAPE_PATTERN;
                            continue block57;
                        }
                        case '%': {
                            switch (patternType) {
                                case NOSPACE: {
                                    LOG.warn("NOSPACE pattern followed immediately by another pattern will greedily consume until whitespace is encountered");
                                    factory.stringUntilWhitespace(GrokParserStageSequenceBuilder.semanticStringToField(semanticString));
                                    factory.whitespace();
                                    break;
                                }
                                case STRING: {
                                    throw new IllegalArgumentException(String.format("Invalid pattern: %s:%s does not have a trailing delimiter, cannot determine end of string", patternString, semanticString));
                                }
                                case INT: {
                                    factory.integer(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                                    break;
                                }
                                case MONTH: {
                                    factory.monthString(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                                }
                            }
                            pattern = new StringBuilder();
                            semantic = new StringBuilder();
                            state = GrokState.START_PATTERN;
                            continue block57;
                        }
                        case ' ': {
                            switch (patternType) {
                                case NOSPACE: 
                                case STRING: {
                                    factory.stringUntilWhitespace(GrokParserStageSequenceBuilder.semanticStringToField(semanticString));
                                    factory.whitespace();
                                    break;
                                }
                                case INT: {
                                    factory.intUntilWhitespace(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                                    factory.whitespace();
                                    break;
                                }
                                case MONTH: {
                                    factory.monthString(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                                    factory.whitespace();
                                }
                            }
                            break;
                        }
                        default: {
                            switch (patternType) {
                                case NOSPACE: {
                                    factory.stringUntil("\\s" + c, GrokParserStageSequenceBuilder.semanticStringToField(semanticString));
                                    factory.character(c);
                                    break block24;
                                }
                                case STRING: {
                                    factory.stringUntil(String.valueOf(c), GrokParserStageSequenceBuilder.semanticStringToField(semanticString));
                                    factory.character(c);
                                    break block24;
                                }
                                case INT: {
                                    factory.integer(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                                    factory.character(c);
                                    break block24;
                                }
                                case MONTH: {
                                    factory.monthString(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                                    factory.character(c);
                                }
                            }
                        }
                    }
                    pattern = new StringBuilder();
                    semantic = new StringBuilder();
                    state = GrokState.TEXT;
                    continue block57;
                }
            }
        }
        if (state == GrokState.END_PATTERN) {
            String patternString = pattern.toString();
            String semanticString = semantic.toString();
            GrokPattern patternType = GrokPattern.valueOf(patternString);
            switch (patternType) {
                case NOSPACE: 
                case STRING: {
                    factory.terminal().string(GrokParserStageSequenceBuilder.semanticStringToField(semanticString));
                    break;
                }
                case INT: {
                    factory.terminal().integer(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                    break;
                }
                case MONTH: {
                    factory.terminal().monthString(GrokParserStageSequenceBuilder.semanticIntegerToField(semanticString));
                }
            }
        }
        return factory.getStages();
    }

    public static enum SyslogSemanticType {
        facilityPriority,
        version,
        year,
        month,
        day,
        hour,
        minute,
        second,
        secondFraction,
        timezone,
        hostname,
        processName,
        processId,
        messageId,
        message;

    }

    private static enum GrokPattern {
        INT,
        MONTH,
        NOSPACE,
        STRING;

    }

    private static enum GrokState {
        TEXT,
        ESCAPE_PATTERN,
        START_PATTERN,
        PATTERN,
        SEMANTIC,
        END_PATTERN;

    }
}

