/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.opennms.core.collections.RadixTree;
import org.opennms.core.collections.RadixTreeImpl;
import org.opennms.core.collections.RadixTreeNode;
import org.opennms.netmgt.syslogd.ByteBufferParser;
import org.opennms.netmgt.syslogd.ParserStage;
import org.opennms.netmgt.syslogd.ParserState;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadixTreeParser
implements ByteBufferParser<SyslogMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(RadixTreeParser.class);
    final RadixTree<ParserStage> tree = new RadixTreeImpl();

    public int size() {
        return this.tree.size();
    }

    public void teach(ParserStage[] stages) {
        this.tree.addChildren((Object[])stages);
    }

    public void performEdgeCompression() {
        for (RadixTreeNode child : this.tree.getChildren()) {
            RadixTreeParser.compressNode((RadixTreeNode<ParserStage>)child);
        }
    }

    public static void compressNode(RadixTreeNode<ParserStage> node) {
        if (node.getChildren() != null) {
            switch (node.getChildren().size()) {
                case 0: {
                    return;
                }
                case 1: {
                    RadixTreeNode child = (RadixTreeNode)node.getChildren().iterator().next();
                    if (node.getContent() instanceof CompositeParserStage) {
                        ((CompositeParserStage)node.getContent()).members.add((ParserStage)child.getContent());
                    } else {
                        CompositeParserStage stage = new CompositeParserStage();
                        stage.members.add((ParserStage)node.getContent());
                        stage.members.add((ParserStage)((RadixTreeNode)node.getChildren().iterator().next()).getContent());
                        node.setContent((Object)stage);
                    }
                    node.setChildren(child.getChildren());
                    RadixTreeParser.compressNode(node);
                    break;
                }
                default: {
                    for (RadixTreeNode current : node.getChildren()) {
                        RadixTreeParser.compressNode((RadixTreeNode<ParserStage>)current);
                    }
                }
            }
        }
    }

    @Override
    public CompletableFuture<SyslogMessage> parse(ByteBuffer incoming) {
        ParserState state = new ParserState(incoming);
        ArrayList<CompletableFuture<ParserState>> finishedFutures = new ArrayList<CompletableFuture<ParserState>>();
        CompletableFuture<ParserState> parent = CompletableFuture.completedFuture(state);
        RadixTreeParser.addStageFutures(finishedFutures, parent, this.tree);
        return RadixTreeParser.firstNonNullResult(finishedFutures).thenApply(s -> {
            if (s == null) {
                return null;
            }
            return s.message;
        });
    }

    private static void addStageFutures(List<CompletableFuture<ParserState>> finishedFutures, CompletableFuture<ParserState> parent, RadixTreeNode<ParserStage> node) {
        CompletionStage<ParserState> current = node.getContent() == null ? parent : parent.thenApply(s -> ((ParserStage)node.getContent()).apply((ParserState)s));
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            for (RadixTreeNode child : node.getChildren()) {
                RadixTreeParser.addStageFutures(finishedFutures, current, (RadixTreeNode<ParserStage>)child);
            }
        } else {
            finishedFutures.add((CompletableFuture<ParserState>)current);
        }
    }

    private static <T> CompletableFuture<T> firstNonNullResult(List<? extends CompletionStage<T>> futures) {
        CompletableFuture parent = new CompletableFuture();
        ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])futures.stream().map(s -> s.thenAccept(t -> {
            if (t != null) {
                if (!parent.complete(t)) {
                    LOG.trace("More than one future completed with a non-null result");
                } else {
                    LOG.trace("Non-null result returned");
                }
            }
        })).toArray(CompletableFuture[]::new)).exceptionally(ex -> {
            parent.complete(null);
            return null;
        })).thenAccept(v -> {
            if (parent.complete(null)) {
                LOG.debug("All futures completed with a null result");
            }
        });
        return parent;
    }

    private static class CompositeParserStage
    implements ParserStage {
        public final List<ParserStage> members = new ArrayList<ParserStage>();

        private CompositeParserStage() {
        }

        @Override
        public ParserState apply(ParserState state) {
            ParserState currentState = state;
            for (ParserStage member : this.members) {
                currentState = member.apply(currentState);
            }
            return currentState;
        }

        @Override
        public void setOptional(boolean optional) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTerminal(boolean terminal) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            buffer.append(this.members.stream().map(Object::toString).collect(Collectors.joining(", ")));
            buffer.append("]");
            return buffer.toString();
        }
    }
}

