/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.HideMatch;
import org.opennms.netmgt.config.syslogd.HostaddrMatch;
import org.opennms.netmgt.config.syslogd.HostnameMatch;
import org.opennms.netmgt.config.syslogd.ParameterAssignment;
import org.opennms.netmgt.config.syslogd.ProcessMatch;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.opennms.netmgt.dao.api.AbstractInterfaceToNodeCache;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToEvent {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertToEvent.class);
    protected static final String HIDDEN_MESSAGE = "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.";
    private final Event m_event;
    private static final LoadingCache<String, Pattern> CACHED_PATTERNS = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String expression) {
            try {
                return Pattern.compile(expression, 8);
            }
            catch (PatternSyntaxException e) {
                LOG.warn("Failed to compile regex pattern '{}'", (Object)expression, (Object)e);
                return null;
            }
        }
    });

    public ConvertToEvent(String systemId, String location, DatagramPacket packet, SyslogdConfig config) throws UnsupportedEncodingException, MessageDiscardedException {
        this(systemId, location, packet.getAddress(), packet.getPort(), new String(packet.getData(), 0, packet.getLength(), "US-ASCII"), config);
    }

    public ConvertToEvent(String systemId, String location, InetAddress addr, int port, String data, SyslogdConfig config) throws UnsupportedEncodingException, MessageDiscardedException {
        UeiMatch uei;
        boolean messageMatchesUeiListEntry;
        SyslogMessage message;
        SyslogParser parser;
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        String syslogString = data;
        while (syslogString.endsWith("\u0000")) {
            syslogString = syslogString.substring(0, syslogString.length() - 1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converting to event: {}", (Object)this);
        }
        if (!(parser = SyslogParser.getParserInstance(config, syslogString)).find()) {
            throw new MessageDiscardedException("message does not match");
        }
        try {
            message = parser.parse();
        }
        catch (SyslogParserException ex) {
            LOG.debug("Unable to parse '{}'", (Object)syslogString, (Object)ex);
            throw new MessageDiscardedException(ex);
        }
        if (message == null) {
            throw new MessageDiscardedException(String.format("Unable to parse '%s'", syslogString));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("got syslog message {}", (Object)message);
        }
        String priorityTxt = message.getSeverity().toString();
        String facilityTxt = message.getFacility().toString();
        EventBuilder bldr = new EventBuilder("uei.opennms.org/syslogd/" + facilityTxt + "/" + priorityTxt, "syslogd");
        bldr.setDistPoller(systemId);
        bldr.setHost(InetAddressUtils.getLocalHostName());
        bldr.setLogDest("logndisplay");
        InetAddress hostAddress = message.getHostAddress();
        if (hostAddress != null) {
            int nodeId;
            InterfaceToNodeCache cache = AbstractInterfaceToNodeCache.getInstance();
            if (cache != null && (nodeId = cache.getNodeId(location, hostAddress)) > 0) {
                bldr.setNodeid((long)nodeId);
            }
            bldr.setInterface(hostAddress);
        }
        bldr.setTime(message.getDate());
        bldr.setLogMessage(message.getMessage());
        bldr.addParam("syslogmessage", message.getMessage());
        bldr.addParam("severity", "" + priorityTxt);
        bldr.addParam("timestamp", message.getRfc3164FormattedDate());
        if (message.getProcessName() != null) {
            bldr.addParam("process", message.getProcessName());
        }
        bldr.addParam("service", "" + facilityTxt);
        if (message.getProcessId() != null) {
            bldr.addParam("processid", message.getProcessId().toString());
        }
        List ueiMatch = config.getUeiList() == null ? Collections.emptyList() : config.getUeiList().getUeiMatchCollection();
        Iterator nodeId = ueiMatch.iterator();
        while (!(!nodeId.hasNext() || (messageMatchesUeiListEntry = ConvertToEvent.containsIgnoreCase((uei = (UeiMatch)nodeId.next()).getFacilityCollection(), facilityTxt) && ConvertToEvent.containsIgnoreCase(uei.getSeverityCollection(), priorityTxt) && ConvertToEvent.matchProcess(uei.getProcessMatch(), message.getProcessName()) && ConvertToEvent.matchHostname(uei.getHostnameMatch(), message.getHostName()) && ConvertToEvent.matchHostAddr(uei.getHostaddrMatch(), InetAddressUtils.str((InetAddress)hostAddress))) && (uei.getMatch().getType().equals("substr") ? ConvertToEvent.matchSubstring(message.getMessage(), uei, bldr, config.getDiscardUei()) : uei.getMatch().getType().startsWith("regex") && ConvertToEvent.matchRegex(message.getMessage(), uei, bldr, config.getDiscardUei())))) {
        }
        String fullText = message.asRfc3164Message();
        List hideMatch = config.getHideMessages() == null ? Collections.emptyList() : config.getHideMessages().getHideMatchCollection();
        boolean doHide = false;
        for (HideMatch hide : hideMatch) {
            if (hide.getMatch().getType().equals("substr")) {
                if (!fullText.contains(hide.getMatch().getExpression())) continue;
                doHide = true;
                break;
            }
            if (!hide.getMatch().getType().equals("regex")) continue;
            try {
                Pattern msgPat = ConvertToEvent.getPattern(hide.getMatch().getExpression());
                Matcher msgMat = msgPat.matcher(fullText);
                if (!msgMat.find()) continue;
                doHide = true;
                break;
            }
            catch (PatternSyntaxException pse) {
                LOG.warn("Failed to compile hide-match regex pattern '{}'", (Object)hide.getMatch().getExpression(), (Object)pse);
            }
        }
        if (doHide) {
            LOG.debug("Hiding syslog message from Event - May contain sensitive data");
            bldr.setLogMessage(HIDDEN_MESSAGE);
            bldr.setParam("syslogmessage", HIDDEN_MESSAGE);
        }
        this.m_event = bldr.getEvent();
    }

    private static boolean matchFind(String expression, String input, String context) {
        if (input == null) {
            return false;
        }
        Pattern pat = ConvertToEvent.getPattern(expression);
        if (pat == null) {
            LOG.debug("Unable to get pattern for expression '{}' in {} context", (Object)expression, (Object)context);
            return false;
        }
        Matcher mat = pat.matcher(input);
        if (mat != null && mat.find()) {
            LOG.trace("Successful regex {} for input '{}' against expression '{}'", new Object[]{context, input, expression});
            return true;
        }
        return false;
    }

    private static boolean matchHostAddr(HostaddrMatch hostaddrMatch, String hostAddress) {
        if (hostaddrMatch == null) {
            return true;
        }
        return ConvertToEvent.matchFind(hostaddrMatch.getExpression(), hostAddress, "hostaddr-match");
    }

    private static boolean matchHostname(HostnameMatch hostnameMatch, String hostName) {
        if (hostnameMatch == null) {
            return true;
        }
        return ConvertToEvent.matchFind(hostnameMatch.getExpression(), hostName, "hostname-match");
    }

    private static boolean matchProcess(ProcessMatch processMatch, String processName) {
        if (processMatch == null) {
            return true;
        }
        return ConvertToEvent.matchFind(processMatch.getExpression(), processName, "process-match");
    }

    private static boolean containsIgnoreCase(List<String> collection, String match) {
        if (collection.size() == 0) {
            return true;
        }
        for (String string : collection) {
            if (!string.equalsIgnoreCase(match)) continue;
            return true;
        }
        return false;
    }

    private static Pattern getPattern(String expression) {
        return (Pattern)CACHED_PATTERNS.getUnchecked((Object)expression);
    }

    private static boolean matchSubstring(String message, UeiMatch uei, EventBuilder bldr, String discardUei) throws MessageDiscardedException {
        boolean traceEnabled = LOG.isTraceEnabled();
        if (message.contains(uei.getMatch().getExpression())) {
            if (discardUei.equals(uei.getUei())) {
                if (traceEnabled) {
                    LOG.trace("Specified UEI '{}' is same as discard-uei, discarding this message.", (Object)uei.getUei());
                }
                throw new MessageDiscardedException();
            }
            if (traceEnabled) {
                LOG.trace("Changed the UEI of a Syslogd event, based on substring match, to : {}", (Object)uei.getUei());
            }
            bldr.setUei(uei.getUei());
            return true;
        }
        if (traceEnabled) {
            LOG.trace("No substring match for text of a Syslogd event to : {}", (Object)uei.getMatch().getExpression());
        }
        return false;
    }

    private static boolean matchRegex(String message, UeiMatch uei, EventBuilder bldr, String discardUei) throws MessageDiscardedException {
        boolean traceEnabled = LOG.isTraceEnabled();
        String expression = uei.getMatch().getExpression();
        Pattern msgPat = ConvertToEvent.getPattern(expression);
        if (msgPat == null) {
            LOG.debug("Unable to create pattern for expression '{}'", (Object)expression);
            return false;
        }
        Matcher msgMat = msgPat.matcher(message);
        if (msgMat != null && msgMat.find()) {
            if (discardUei.equals(uei.getUei())) {
                if (traceEnabled) {
                    LOG.trace("Specified UEI '{}' is same as discard-uei, discarding this message.", (Object)uei.getUei());
                }
                throw new MessageDiscardedException();
            }
            if (traceEnabled) {
                LOG.trace("Changed the UEI of a Syslogd event, based on regex match, to : {}", (Object)uei.getUei());
            }
            bldr.setUei(uei.getUei());
            if (msgMat.groupCount() > 0) {
                if (uei.getMatch().isDefaultParameterMapping()) {
                    if (traceEnabled) {
                        LOG.trace("Doing default parameter mappings for this regex match.");
                    }
                    for (int groupNum = 1; groupNum <= msgMat.groupCount(); ++groupNum) {
                        if (traceEnabled) {
                            LOG.trace("Added parm 'group{}' with value '{}' to Syslogd event based on regex match group", (Object)groupNum, (Object)msgMat.group(groupNum));
                        }
                        bldr.addParam("group" + groupNum, msgMat.group(groupNum));
                    }
                }
                if (uei.getParameterAssignmentCount() > 0) {
                    if (traceEnabled) {
                        LOG.trace("Doing user-specified parameter assignments for this regex match.");
                    }
                    for (ParameterAssignment assignment : uei.getParameterAssignmentCollection()) {
                        String parmName = assignment.getParameterName();
                        String parmValue = msgMat.group(assignment.getMatchingGroup());
                        parmValue = parmValue == null ? "" : parmValue;
                        bldr.addParam(parmName, parmValue);
                        if (!traceEnabled) continue;
                        LOG.trace("Added parm '{}' with value '{}' to Syslogd event based on user-specified parameter assignment", (Object)parmName, (Object)parmValue);
                    }
                }
            }
            return true;
        }
        if (traceEnabled) {
            LOG.trace("Message portion '{}' did not regex-match pattern '{}'", (Object)message, (Object)expression);
        }
        return false;
    }

    public Event getEvent() {
        return this.m_event;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Event", (Object)this.m_event).toString();
    }
}

