/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultManagementNameStrategy;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.Registry;
import org.jboss.netty.buffer.ChannelBuffer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.SinkDispatchingSyslogReceiver;
import org.opennms.netmgt.syslogd.api.SyslogConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiverCamelNettyImpl
extends SinkDispatchingSyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverCamelNettyImpl.class);
    private static final int SOCKET_TIMEOUT = 500;
    private final InetAddress m_host;
    private final int m_port;
    private final SyslogdConfig m_config;
    private DefaultCamelContext m_camel;

    public SyslogReceiverCamelNettyImpl(SyslogdConfig config) {
        super(config);
        this.m_host = InetAddressUtils.addr((String)(config.getListenAddress() == null ? "0.0.0.0" : config.getListenAddress()));
        this.m_port = config.getSyslogPort();
        this.m_config = config;
    }

    @Override
    public String getName() {
        String listenAddress = this.m_config.getListenAddress() == null ? "0.0.0.0" : this.m_config.getListenAddress();
        return this.getClass().getSimpleName() + " [" + listenAddress + ":" + this.m_config.getSyslogPort() + "]";
    }

    @Override
    public void stop() throws InterruptedException {
        try {
            if (this.m_camel != null) {
                this.m_camel.shutdown();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while shutting down syslog Camel context", (Throwable)e);
        }
        super.stop();
    }

    @Override
    public void run() {
        super.run();
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"dispatcher", (Object)this.m_dispatcher);
        NettyComponent nettyComponent = new NettyComponent();
        this.m_camel = new DefaultCamelContext((Registry)registry);
        this.m_camel.setName("syslogdListenerCamelNettyContext");
        this.m_camel.setManagementNameStrategy((ManagementNameStrategy)new DefaultManagementNameStrategy((CamelContext)this.m_camel, "#name#", null));
        this.m_camel.addComponent("netty", (Component)nettyComponent);
        this.m_camel.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.m_camel.getShutdownStrategy().setTimeout(15L);
        this.m_camel.getShutdownStrategy().setTimeUnit(TimeUnit.SECONDS);
        try {
            this.m_camel.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    String from = String.format("netty:udp://%s:%d?sync=false&allowDefaultCodec=false&receiveBufferSize=%d&connectTimeout=%d&synchronous=true&orderedThreadPoolExecutor=false", InetAddressUtils.str((InetAddress)SyslogReceiverCamelNettyImpl.this.m_host), SyslogReceiverCamelNettyImpl.this.m_port, Integer.MAX_VALUE, 500);
                    ((RouteDefinition)this.from(from).routeId("syslogListen").process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            ChannelBuffer buffer = (ChannelBuffer)exchange.getIn().getBody(ChannelBuffer.class);
                            InetSocketAddress source = (InetSocketAddress)exchange.getIn().getHeader("CamelNettyRemoteAddress");
                            ByteBuffer byteBuffer = buffer.toByteBuffer();
                            SyslogConnection connection = new SyslogConnection(source, byteBuffer);
                            exchange.getIn().setBody((Object)connection, SyslogConnection.class);
                        }
                    })).to("bean:dispatcher?method=send");
                }
            });
            this.m_camel.start();
        }
        catch (Throwable e) {
            LOG.error("Could not configure Camel routes for syslog receiver", e);
        }
    }
}

