/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2016-2016 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2016 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.netmgt.syslogd;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.core.camel.MinionDTO;
import org.opennms.core.utils.InetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogDTOToObjectProcessor implements Processor {
	public static final Logger LOG = LoggerFactory.getLogger(SyslogDTOToObjectProcessor.class);

	@Override
	public void process(final Exchange exchange) throws Exception {
		final SyslogDTO object = exchange.getIn().getBody(SyslogDTO.class);
		exchange.getIn().setBody(dto2object(object), SyslogConnection.class);
	}

	public static SyslogConnection dto2object(SyslogDTO syslogDto) {
		SyslogConnection syslog = new SyslogConnection();

		syslog.setLocation(syslogDto.getHeader(MinionDTO.LOCATION));
		syslog.setSourceAddress(InetAddressUtils.getInetAddress(syslogDto.getHeader(MinionDTO.SOURCE_ADDRESS)));
		syslog.setPort(Integer.parseInt(syslogDto.getHeader(MinionDTO.SOURCE_PORT)));
		syslog.setSystemId(syslogDto.getHeader(MinionDTO.SYSTEM_ID));

		if(syslogDto.getBody() != null && syslogDto.getBody().length > 0){
			syslog.setBytes(syslogDto.getBody());
		}

		return syslog;
	}
}
