/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogObjectToDTOProcessor
implements Processor {
    public static final Logger LOG = LoggerFactory.getLogger(SyslogObjectToDTOProcessor.class);
    public static final String INCLUDE_RAW_MESSAGE = "includeRawMessage";
    public static final boolean INCLUDE_RAW_MESSAGE_DEFAULT = Boolean.TRUE;

    public void process(Exchange exchange) throws Exception {
        SyslogConnection object = (SyslogConnection)exchange.getIn().getBody(SyslogConnection.class);
        boolean syslogRawMessageFlag = (Boolean)exchange.getIn().getHeader(INCLUDE_RAW_MESSAGE);
        exchange.getIn().setBody((Object)SyslogObjectToDTOProcessor.object2dto(object, syslogRawMessageFlag), SyslogDTO.class);
    }

    public static SyslogDTO object2dto(SyslogConnection syslog) {
        return SyslogObjectToDTOProcessor.object2dto(syslog, INCLUDE_RAW_MESSAGE_DEFAULT);
    }

    public static SyslogDTO object2dto(SyslogConnection syslog, boolean syslogRawMessageFlag) {
        SyslogDTO syslogDTO = new SyslogDTO();
        syslogDTO.setLocation(syslog.getLocation());
        syslogDTO.setSourceAddress(syslog.getSourceAddress());
        syslogDTO.setSourcePort(syslog.getPort());
        syslogDTO.setSystemId(syslog.getSystemId());
        if (syslogRawMessageFlag) {
            syslogDTO.setBody(syslog.getBytes());
        }
        return syslogDTO;
    }
}

