/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultManagementNameStrategy;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.Registry;
import org.jboss.netty.buffer.ChannelBuffer;
import org.opennms.core.camel.DispatcherWhiteboard;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiverCamelNettyImpl
implements SyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverCamelNettyImpl.class);
    private static final MetricRegistry METRICS = new MetricRegistry();
    private static final int SOCKET_TIMEOUT = 500;
    private final InetAddress m_host;
    private final int m_port;
    private final SyslogdConfig m_config;
    private DefaultCamelContext m_camel;
    private DistPollerDao m_distPollerDao = null;
    private DispatcherWhiteboard syslogDispatcher;

    public SyslogReceiverCamelNettyImpl(SyslogdConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.m_host = config.getListenAddress() == null ? InetAddressUtils.addr((String)"0.0.0.0") : InetAddressUtils.addr((String)config.getListenAddress());
        this.m_port = config.getSyslogPort();
        this.m_config = config;
    }

    @Override
    public String getName() {
        String listenAddress = this.m_config.getListenAddress() != null && this.m_config.getListenAddress().length() > 0 ? this.m_config.getListenAddress() : "0.0.0.0";
        return this.getClass().getSimpleName() + " [" + listenAddress + ":" + this.m_config.getSyslogPort() + "]";
    }

    @Override
    public void stop() throws InterruptedException {
        try {
            this.m_camel.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Exception while shutting down syslog Camel context", (Throwable)e);
        }
    }

    public DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    @Override
    public void run() {
        Logging.putPrefix((String)"syslogd");
        final Meter packetMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"packets"}));
        Meter connectionMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"connections"}));
        final Histogram packetSizeHistogram = METRICS.histogram(MetricRegistry.name(this.getClass(), (String[])new String[]{"packetSize"}));
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"syslogDispatcher", (Object)this.syslogDispatcher);
        NettyComponent nettyComponent = new NettyComponent();
        this.m_camel = new DefaultCamelContext((Registry)registry);
        this.m_camel.setName("syslogdListenerCamelNettyContext");
        this.m_camel.setManagementNameStrategy((ManagementNameStrategy)new DefaultManagementNameStrategy((CamelContext)this.m_camel, "#name#", null));
        this.m_camel.addComponent("netty", (Component)nettyComponent);
        try {
            this.m_camel.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    String from = String.format("netty:udp://%s:%s?sync=false&allowDefaultCodec=false&receiveBufferSize=%d&connectTimeout=%d", InetAddressUtils.str((InetAddress)SyslogReceiverCamelNettyImpl.this.m_host), SyslogReceiverCamelNettyImpl.this.m_port, Integer.MAX_VALUE, 500);
                    ((RouteDefinition)this.from(from).routeId("syslogListen").process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            ChannelBuffer buffer = (ChannelBuffer)exchange.getIn().getBody(ChannelBuffer.class);
                            InetSocketAddress source = (InetSocketAddress)exchange.getIn().getHeader("CamelNettyRemoteAddress");
                            ByteBuffer byteBuffer = buffer.toByteBuffer();
                            packetMeter.mark();
                            packetSizeHistogram.update(byteBuffer.remaining());
                            SyslogConnection connection = new SyslogConnection(source.getAddress(), source.getPort(), byteBuffer, SyslogReceiverCamelNettyImpl.this.m_config, SyslogReceiverCamelNettyImpl.this.m_distPollerDao.whoami().getId(), SyslogReceiverCamelNettyImpl.this.m_distPollerDao.whoami().getLocation());
                            exchange.getIn().setBody((Object)connection, SyslogConnection.class);
                        }
                    })).to("bean:syslogDispatcher?method=dispatch");
                }
            });
            this.m_camel.start();
        }
        catch (Throwable e) {
            LOG.error("Could not configure Camel routes for syslog receiver", e);
        }
    }

    public DispatcherWhiteboard getSyslogDispatcher() {
        return this.syslogDispatcher;
    }

    public void setSyslogDispatcher(DispatcherWhiteboard syslogDispatcher) {
        this.syslogDispatcher = syslogDispatcher;
    }
}

