/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogConnectionHandler;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiverNioThreadPoolImpl
implements SyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverNioThreadPoolImpl.class);
    private static final MetricRegistry METRICS = new MetricRegistry();
    private static final int SOCKET_TIMEOUT = 500;
    public static final int MAX_PACKET_SIZE = 4096;
    public static final int SOCKET_RECEIVER_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private volatile boolean m_stop;
    private DatagramChannel m_channel;
    private Thread m_context;
    private final SyslogdConfig m_config;
    private final ExecutorService m_socketReceivers;
    private List<SyslogConnectionHandler> m_syslogConnectionHandlers = Collections.emptyList();

    public static DatagramChannel openChannel(SyslogdConfig config) throws SocketException, IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.socket().setReuseAddress(true);
        if (config.getListenAddress() != null && config.getListenAddress().length() != 0) {
            channel.socket().bind(new InetSocketAddress(InetAddressUtils.addr((String)config.getListenAddress()), config.getSyslogPort()));
        } else {
            channel.socket().bind(new InetSocketAddress(config.getSyslogPort()));
        }
        return channel;
    }

    public SyslogReceiverNioThreadPoolImpl(SyslogdConfig config) throws SocketException, IOException {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.m_stop = false;
        this.m_channel = null;
        this.m_config = config;
        this.m_socketReceivers = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName() + "-SocketReceiver", Integer.MAX_VALUE));
    }

    @Override
    public String getName() {
        String listenAddress = this.m_config.getListenAddress() != null && this.m_config.getListenAddress().length() > 0 ? this.m_config.getListenAddress() : "0.0.0.0";
        return this.getClass().getSimpleName() + " [" + listenAddress + ":" + this.m_config.getSyslogPort() + "]";
    }

    @Override
    public void stop() throws InterruptedException {
        this.m_stop = true;
        this.m_socketReceivers.shutdown();
        try {
            this.m_channel.close();
        }
        catch (IOException e) {
            LOG.warn("Exception while closing syslog channel: " + e.getMessage());
        }
        finally {
            this.m_channel = null;
        }
        if (this.m_context != null) {
            LOG.debug("Stopping and joining thread context {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined");
        }
    }

    public SyslogConnectionHandler getSyslogConnectionHandlers() {
        return this.m_syslogConnectionHandlers.get(0);
    }

    public void setSyslogConnectionHandlers(SyslogConnectionHandler handler) {
        this.m_syslogConnectionHandlers = Collections.singletonList(handler);
    }

    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        Logging.putPrefix((String)"syslogd");
        final Meter packetMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"packets"}));
        final Meter connectionMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"connections"}));
        final Histogram packetSizeHistogram = METRICS.histogram(MetricRegistry.name(this.getClass(), (String[])new String[]{"packetSize"}));
        if (this.m_stop) {
            LOG.debug("Stop flag set before thread started, exiting");
            return;
        }
        LOG.debug("Thread context started");
        try {
            LOG.debug("Opening syslog channel...");
            this.m_channel = SyslogReceiverNioThreadPoolImpl.openChannel(this.m_config);
        }
        catch (IOException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Setting socket timeout to {}ms", (Object)500);
            this.m_channel.socket().setSoTimeout(500);
        }
        catch (SocketException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Attempting to set receive buffer size to {}", (Object)Integer.MAX_VALUE);
            this.m_channel.socket().setReceiveBufferSize(Integer.MAX_VALUE);
            LOG.debug("Actual receive buffer size is {}", (Object)this.m_channel.socket().getReceiveBufferSize());
        }
        catch (SocketException e) {
            LOG.info("Failed to set the receive buffer to {}", (Object)Integer.MAX_VALUE, (Object)e);
        }
        for (int i = 0; i < SOCKET_RECEIVER_COUNT; ++i) {
            this.m_socketReceivers.execute(new Runnable(){

                @Override
                public void run() {
                    boolean ioInterrupted = false;
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    buffer.clear();
                    while (!SyslogReceiverNioThreadPoolImpl.this.m_stop) {
                        if (SyslogReceiverNioThreadPoolImpl.this.m_context.isInterrupted()) {
                            LOG.debug("Thread context interrupted");
                            break;
                        }
                        try {
                            if (!ioInterrupted) {
                                LOG.debug("Waiting on a datagram to arrive");
                            }
                            InetSocketAddress source = (InetSocketAddress)SyslogReceiverNioThreadPoolImpl.this.m_channel.receive(buffer);
                            packetMeter.mark();
                            buffer.flip();
                            packetSizeHistogram.update(buffer.remaining());
                            SyslogConnection connection = new SyslogConnection(SyslogConnection.copyPacket(source.getAddress(), source.getPort(), buffer), SyslogReceiverNioThreadPoolImpl.this.m_config);
                            try {
                                for (SyslogConnectionHandler handler : SyslogReceiverNioThreadPoolImpl.this.m_syslogConnectionHandlers) {
                                    connectionMeter.mark();
                                    handler.handleSyslogConnection(connection);
                                }
                            }
                            catch (Throwable e) {
                                LOG.error("Handler execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
                            }
                            buffer.clear();
                            ioInterrupted = false;
                        }
                        catch (SocketTimeoutException e) {
                            ioInterrupted = true;
                        }
                        catch (InterruptedIOException e) {
                            ioInterrupted = true;
                        }
                        catch (IOException e) {
                            ioInterrupted = true;
                        }
                        catch (Throwable e) {
                            LOG.error("Task execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
                            break;
                        }
                    }
                    LOG.debug("Thread context exiting");
                }
            });
        }
    }
}

