/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.jboss.netty.buffer.ChannelBuffer;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogConnectionHandler;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.opennms.netmgt.syslogd.SyslogReceiverNioThreadPoolImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiverCamelNettyImpl
implements SyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverNioThreadPoolImpl.class);
    private static final MetricRegistry METRICS = new MetricRegistry();
    private static final int SOCKET_TIMEOUT = 500;
    private final InetAddress m_host;
    private final int m_port;
    private final SyslogdConfig m_config;
    private DefaultCamelContext m_camel;
    private List<SyslogConnectionHandler> m_syslogConnectionHandlers = Collections.emptyList();

    public SyslogReceiverCamelNettyImpl(SyslogdConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.m_host = config.getListenAddress() == null ? InetAddressUtils.addr((String)"0.0.0.0") : InetAddressUtils.addr((String)config.getListenAddress());
        this.m_port = config.getSyslogPort();
        this.m_config = config;
    }

    @Override
    public String getName() {
        String listenAddress = this.m_config.getListenAddress() != null && this.m_config.getListenAddress().length() > 0 ? this.m_config.getListenAddress() : "0.0.0.0";
        return this.getClass().getSimpleName() + " [" + listenAddress + ":" + this.m_config.getSyslogPort() + "]";
    }

    @Override
    public void stop() throws InterruptedException {
        try {
            this.m_camel.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Exception while shutting down syslog Camel context", (Throwable)e);
        }
    }

    public SyslogConnectionHandler getSyslogConnectionHandlers() {
        return this.m_syslogConnectionHandlers.get(0);
    }

    public void setSyslogConnectionHandlers(SyslogConnectionHandler handler) {
        this.m_syslogConnectionHandlers = Collections.singletonList(handler);
    }

    @Override
    public void run() {
        Logging.putPrefix((String)"syslogd");
        final Meter packetMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"packets"}));
        final Meter connectionMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"connections"}));
        final Histogram packetSizeHistogram = METRICS.histogram(MetricRegistry.name(this.getClass(), (String[])new String[]{"packetSize"}));
        SimpleRegistry registry = new SimpleRegistry();
        NettyComponent nettyComponent = new NettyComponent();
        this.m_camel = new DefaultCamelContext((Registry)registry);
        this.m_camel.addComponent("netty", (Component)nettyComponent);
        try {
            this.m_camel.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    String from = String.format("netty:udp://%s:%s?sync=false&allowDefaultCodec=false&receiveBufferSize=%d&connectTimeout=%d", InetAddressUtils.str((InetAddress)SyslogReceiverCamelNettyImpl.this.m_host), SyslogReceiverCamelNettyImpl.this.m_port, Integer.MAX_VALUE, 500);
                    this.from(from).process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            ChannelBuffer buffer = (ChannelBuffer)exchange.getIn().getBody(ChannelBuffer.class);
                            InetSocketAddress source = (InetSocketAddress)exchange.getIn().getHeader("CamelNettyRemoteAddress");
                            ByteBuffer byteBuffer = buffer.toByteBuffer();
                            packetMeter.mark();
                            packetSizeHistogram.update(byteBuffer.remaining());
                            SyslogConnection connection = new SyslogConnection(source.getAddress(), source.getPort(), byteBuffer, SyslogReceiverCamelNettyImpl.this.m_config);
                            try {
                                for (SyslogConnectionHandler handler : SyslogReceiverCamelNettyImpl.this.m_syslogConnectionHandlers) {
                                    connectionMeter.mark();
                                    handler.handleSyslogConnection(connection);
                                }
                            }
                            catch (Throwable e) {
                                LOG.error("Handler execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
                            }
                        }
                    });
                }
            });
            this.m_camel.start();
        }
        catch (Throwable e) {
            LOG.error("Could not configure Camel routes for syslog receiver", e);
        }
    }
}

