/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.CustomSyslogParser;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogParser {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogParser.class);
    private static final String datePattern = "((19|20)\\d{2})-([1-9]|0[1-9]|1[0-2])-(0[1-9]|[1-9]|[12][0-9]|3[01])";
    private Matcher m_matcher = null;
    private final SyslogdConfig m_config;
    private final String m_text;
    private Boolean m_found = null;
    private Boolean m_matched = null;
    private boolean m_traceEnabled = false;

    public static SyslogParser getParserInstance(SyslogdConfig config, String text) throws MessageDiscardedException {
        SyslogParser retval;
        Class<SyslogParser> m_parserClass = null;
        try {
            m_parserClass = Class.forName(config.getParser()).asSubclass(SyslogParser.class);
        }
        catch (Exception ex) {
            LOG.debug("Unable to instantiate Syslog parser class specified in config: {}", (Object)config.getParser(), (Object)ex);
            m_parserClass = CustomSyslogParser.class;
        }
        try {
            Constructor<SyslogParser> m = m_parserClass.getConstructor(SyslogdConfig.class, String.class);
            retval = m.newInstance(config, text);
        }
        catch (Exception ex) {
            LOG.debug("Unable to get parser for class '{}'", (Object)m_parserClass.getName(), (Object)ex);
            throw new MessageDiscardedException(ex);
        }
        return retval;
    }

    protected SyslogParser(SyslogdConfig config, String text) {
        if (config == null) {
            throw new IllegalArgumentException("Config argument to SyslogParser must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text argument to SyslogParser must not be null");
        }
        this.m_config = config;
        this.m_text = text;
        this.m_traceEnabled = LOG.isTraceEnabled();
    }

    public boolean find() {
        if (this.m_found == null) {
            this.getMatcher().reset();
            this.m_found = this.getMatcher().find();
        }
        return this.m_found;
    }

    public boolean matches() {
        if (this.m_matched == null) {
            this.getMatcher().reset();
            this.m_matched = this.getMatcher().matches();
        }
        return this.m_matched;
    }

    protected Boolean matched() {
        return this.m_matched;
    }

    protected SyslogdConfig getConfig() {
        return this.m_config;
    }

    protected String getText() {
        return this.m_text;
    }

    protected boolean traceEnabled() {
        return this.m_traceEnabled;
    }

    protected Pattern getPattern() {
        return Pattern.compile("^.*$");
    }

    public SyslogMessage parse() throws SyslogParserException {
        SyslogMessage message = new SyslogMessage();
        message.setMessage(this.getMatcher().group().trim());
        return message;
    }

    protected Matcher getMatcher() {
        if (this.m_matcher == null) {
            this.m_matcher = this.getPattern().matcher(this.m_text);
        }
        return this.m_matcher;
    }

    protected static Date parseDate(String dateString) {
        try {
            if (dateString.matches(datePattern)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                return df.parse(dateString);
            }
            SimpleDateFormat df = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.ROOT);
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = df.parse(dateString);
            Calendar c = df.getCalendar();
            c.setTime(date);
            c.set(1, Calendar.getInstance().get(1));
            return c.getTime();
        }
        catch (Exception e) {
            LOG.debug("Unable to parse date '{}'", (Object)dateString, (Object)e);
            return null;
        }
    }
}

