/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.opennms.core.concurrent.ExecutorFactory;
import org.opennms.core.concurrent.ExecutorFactoryJavaImpl;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogConnectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogConnectionHandlerDefaultImpl
implements SyslogConnectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogConnectionHandlerDefaultImpl.class);
    public static final int EVENT_PARSER_THREADS = Runtime.getRuntime().availableProcessors();
    public static final int EVENT_SENDER_THREADS = Runtime.getRuntime().availableProcessors();
    private final ExecutorFactory m_executorFactory = new ExecutorFactoryJavaImpl();
    private final ExecutorService m_syslogConnectionExecutor = this.m_executorFactory.newExecutor(EVENT_PARSER_THREADS, Integer.MAX_VALUE, "OpenNMS.Syslogd", "syslogConnections");
    private final ExecutorService m_syslogProcessorExecutor = this.m_executorFactory.newExecutor(EVENT_SENDER_THREADS, Integer.MAX_VALUE, "OpenNMS.Syslogd", "syslogProcessors");

    @Override
    public void handleSyslogConnection(SyslogConnection message) {
        try {
            CompletableFuture.supplyAsync(message::call, this.m_syslogConnectionExecutor).thenAcceptAsync(proc -> proc.call(), (Executor)this.m_syslogProcessorExecutor);
        }
        catch (Throwable e) {
            LOG.error("Task execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }
}

