/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.concurrent.WaterfallExecutor;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiverNioThreadPoolImpl
implements SyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverNioThreadPoolImpl.class);
    private static final int SOCKET_TIMEOUT = 500;
    public static final int MAX_PACKET_SIZE = 4096;
    public static final int SOCKET_RECEIVER_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private volatile boolean m_stop;
    private DatagramChannel m_channel;
    private Thread m_context;
    private final SyslogdConfig m_config;
    private final ExecutorService m_executor;
    private final ExecutorService m_socketReceivers;

    public static DatagramChannel openChannel(SyslogdConfig config) throws SocketException, IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.socket().setReuseAddress(true);
        if (config.getListenAddress() != null && config.getListenAddress().length() != 0) {
            channel.socket().bind(new InetSocketAddress(InetAddressUtils.addr((String)config.getListenAddress()), config.getSyslogPort()));
        } else {
            channel.socket().bind(new InetSocketAddress(config.getSyslogPort()));
        }
        return channel;
    }

    public SyslogReceiverNioThreadPoolImpl(SyslogdConfig config) throws SocketException, IOException {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.m_stop = false;
        this.m_channel = null;
        this.m_config = config;
        this.m_executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), Integer.MAX_VALUE));
        this.m_socketReceivers = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName() + "-SocketReceiver", Integer.MAX_VALUE));
    }

    @Override
    public String getName() {
        String listenAddress = this.m_config.getListenAddress() != null && this.m_config.getListenAddress().length() > 0 ? this.m_config.getListenAddress() : "0.0.0.0";
        return this.getClass().getSimpleName() + " [" + listenAddress + ":" + this.m_config.getSyslogPort() + "]";
    }

    @Override
    public void stop() throws InterruptedException {
        this.m_stop = true;
        this.m_socketReceivers.shutdown();
        this.m_executor.shutdown();
        try {
            this.m_channel.close();
        }
        catch (IOException e) {
            LOG.warn("Exception while closing syslog channel: " + e.getMessage());
        }
        finally {
            this.m_channel = null;
        }
        if (this.m_context != null) {
            LOG.debug("Stopping and joining thread context {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined");
        }
    }

    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        Logging.putPrefix((String)"syslogd");
        if (this.m_stop) {
            LOG.debug("Stop flag set before thread started, exiting");
            return;
        }
        LOG.debug("Thread context started");
        try {
            LOG.debug("Opening syslog channel...");
            this.m_channel = SyslogReceiverNioThreadPoolImpl.openChannel(this.m_config);
        }
        catch (IOException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Setting socket timeout to {}ms", (Object)500);
            this.m_channel.socket().setSoTimeout(500);
        }
        catch (SocketException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Attempting to set receive buffer size to {}", (Object)Integer.MAX_VALUE);
            this.m_channel.socket().setReceiveBufferSize(Integer.MAX_VALUE);
            LOG.debug("Actual receive buffer size is {}", (Object)this.m_channel.socket().getReceiveBufferSize());
        }
        catch (SocketException e) {
            LOG.info("Failed to set the receive buffer to {}", (Object)Integer.MAX_VALUE, (Object)e);
        }
        for (int i = 0; i < SOCKET_RECEIVER_COUNT; ++i) {
            this.m_socketReceivers.execute(new Runnable(){

                @Override
                public void run() {
                    boolean ioInterrupted = false;
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    buffer.clear();
                    while (!SyslogReceiverNioThreadPoolImpl.this.m_stop) {
                        if (SyslogReceiverNioThreadPoolImpl.this.m_context.isInterrupted()) {
                            LOG.debug("Thread context interrupted");
                            break;
                        }
                        try {
                            if (!ioInterrupted) {
                                LOG.debug("Waiting on a datagram to arrive");
                            }
                            InetSocketAddress source = (InetSocketAddress)SyslogReceiverNioThreadPoolImpl.this.m_channel.receive(buffer);
                            buffer.flip();
                            WaterfallExecutor.waterfall((Executor)SyslogReceiverNioThreadPoolImpl.this.m_executor, (Callable)new SyslogConnection(SyslogConnection.copyPacket(source.getAddress(), source.getPort(), buffer), SyslogReceiverNioThreadPoolImpl.this.m_config));
                            buffer.clear();
                            ioInterrupted = false;
                        }
                        catch (SocketTimeoutException e) {
                            ioInterrupted = true;
                        }
                        catch (InterruptedIOException e) {
                            ioInterrupted = true;
                        }
                        catch (ExecutionException e) {
                            LOG.error("Task execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
                            break;
                        }
                        catch (InterruptedException e) {
                            LOG.error("Task interrupted in {}", (Object)this.getClass().getSimpleName(), (Object)e);
                            break;
                        }
                        catch (IOException e) {
                            LOG.error("An I/O exception occured on the datagram receipt port, exiting", (Throwable)e);
                            break;
                        }
                    }
                    LOG.debug("Thread context exiting");
                }
            });
        }
    }
}

