/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.jboss.netty.buffer.ChannelBuffer;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.concurrent.WaterfallExecutor;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.opennms.netmgt.syslogd.SyslogReceiverNioThreadPoolImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiverCamelNettyImpl
implements SyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverNioThreadPoolImpl.class);
    private static final int SOCKET_TIMEOUT = 500;
    private final InetAddress m_host;
    private final int m_port;
    private final SyslogdConfig m_config;
    private final ExecutorService m_executor;
    private DefaultCamelContext m_camel;

    public SyslogReceiverCamelNettyImpl(SyslogdConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.m_host = config.getListenAddress() == null ? InetAddressUtils.addr((String)"0.0.0.0") : InetAddressUtils.addr((String)config.getListenAddress());
        this.m_port = config.getSyslogPort();
        this.m_config = config;
        this.m_executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), Integer.MAX_VALUE));
    }

    @Override
    public String getName() {
        String listenAddress = this.m_config.getListenAddress() != null && this.m_config.getListenAddress().length() > 0 ? this.m_config.getListenAddress() : "0.0.0.0";
        return this.getClass().getSimpleName() + " [" + listenAddress + ":" + this.m_config.getSyslogPort() + "]";
    }

    @Override
    public void stop() throws InterruptedException {
        try {
            this.m_camel.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Exception while shutting down syslog Camel context", (Throwable)e);
        }
        this.m_executor.shutdown();
    }

    @Override
    public void run() {
        Logging.putPrefix((String)"syslogd");
        SimpleRegistry registry = new SimpleRegistry();
        this.m_camel = new DefaultCamelContext((Registry)registry);
        try {
            this.m_camel.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    String from = String.format("netty:udp://%s:%s?sync=false&allowDefaultCodec=false&receiveBufferSize=%d&connectTimeout=%d", InetAddressUtils.str((InetAddress)SyslogReceiverCamelNettyImpl.this.m_host), SyslogReceiverCamelNettyImpl.this.m_port, Integer.MAX_VALUE, 500);
                    this.from(from).process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            ChannelBuffer buffer = (ChannelBuffer)exchange.getIn().getBody(ChannelBuffer.class);
                            InetSocketAddress source = (InetSocketAddress)exchange.getIn().getHeader("CamelNettyRemoteAddress");
                            WaterfallExecutor.waterfall((Executor)SyslogReceiverCamelNettyImpl.this.m_executor, (Callable)new SyslogConnection(source.getAddress(), source.getPort(), buffer.toByteBuffer(), SyslogReceiverCamelNettyImpl.this.m_config));
                        }
                    });
                }
            });
            this.m_camel.start();
        }
        catch (Exception e) {
            LOG.error("Could not configure Camel routes for syslog receiver", (Throwable)e);
        }
    }
}

