/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor.expandable;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.processor.expandable.ExpandableConstant;
import org.opennms.netmgt.eventd.processor.expandable.ExpandableParameter;
import org.opennms.netmgt.eventd.processor.expandable.ExpandableToken;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTemplate
implements ExpandableToken {
    private static final Logger LOG = LoggerFactory.getLogger(EventTemplate.class);
    private static final char PERCENT = '%';
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile(".*\\s(?s).*");
    private final String input;
    private final List<ExpandableToken> tokens = Lists.newArrayList();
    private final EventUtil eventUtil;
    private final boolean requiresTransaction;

    public EventTemplate(String input, EventUtil eventUtil) {
        this.input = Objects.requireNonNull(input);
        this.eventUtil = Objects.requireNonNull(eventUtil);
        this.parse();
        this.requiresTransaction = this.tokens.stream().filter(ExpandableToken::requiresTransaction).findAny().isPresent();
    }

    private void parse() {
        this.tokens.clear();
        String tempInp = this.input;
        int inpLen = this.input.length();
        int index1 = -1;
        int index2 = -1;
        while (tempInp != null && (index1 = tempInp.indexOf(37)) != -1) {
            LOG.debug("checking input {}", (Object)tempInp);
            this.tokens.add(new ExpandableConstant(tempInp.substring(0, index1)));
            tempInp = tempInp.substring(index1);
            index2 = tempInp.indexOf(37, 1);
            if (index2 == 1) {
                this.tokens.add(new ExpandableConstant('%'));
                tempInp = tempInp.substring(index2 + 1);
                LOG.debug("Escaped percent %% found in value");
                continue;
            }
            if (index2 == -1) break;
            String parm = tempInp.substring(1, index2);
            LOG.debug("parm: {} found in value", (Object)parm);
            if (WHITESPACE_PATTERN.matcher(parm).matches()) {
                this.tokens.add(new ExpandableConstant('%'));
                tempInp = tempInp.substring(1);
                LOG.debug("skipping parm: {} because whitespace found in value", (Object)parm);
                continue;
            }
            this.tokens.add(new ExpandableParameter(parm, this.eventUtil));
            if (index2 < inpLen - 1) {
                tempInp = tempInp.substring(index2 + 1);
                continue;
            }
            tempInp = null;
        }
        if ((index1 == -1 || index2 == -1) && tempInp != null) {
            this.tokens.add(new ExpandableConstant(tempInp));
        }
    }

    @Override
    public String expand(Event event, Map<String, Map<String, String>> decode) {
        String collect = this.tokens.stream().map(t -> t.expand(event, decode)).collect(Collectors.joining());
        return collect;
    }

    @Override
    public boolean requiresTransaction() {
        return this.requiresTransaction;
    }
}

