/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XmlEventProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlEventProcessor.class);
    private EventForwarder m_eventForwarder;

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public void process(Exchange exchange) {
        InputStream stream = (InputStream)exchange.getIn().getBody(InputStream.class);
        Log eventLog = null;
        try {
            eventLog = (Log)JaxbUtils.unmarshal(Log.class, (InputSource)new InputSource(stream));
            LOG.debug("Event record converted");
        }
        catch (Throwable e) {
            LOG.error("Could not unmarshal the XML record", e);
            throw e;
        }
        Event[] events = eventLog.getEvents().getEvent();
        if (events != null && events.length != 0) {
            Arrays.sort(events, new Comparator<Event>(){

                @Override
                public int compare(Event e1, Event e2) {
                    boolean e2t;
                    boolean e1t = e1.getTime() != null;
                    boolean bl = e2t = e2.getTime() != null;
                    if (e1t && !e2t) {
                        return 1;
                    }
                    if (!e1t && e2t) {
                        return -1;
                    }
                    if (!e1t && !e2t) {
                        return 0;
                    }
                    Date de1 = e1.getTime();
                    Date de2 = e2.getTime();
                    if (de1 != null && de2 != null) {
                        return (int)(de1.getTime() - de2.getTime());
                    }
                    if (de1 == null && de2 != null) {
                        return -1;
                    }
                    if (de1 != null && de2 == null) {
                        return 1;
                    }
                    return 0;
                }
            });
            ArrayList<Event> okEvents = new ArrayList<Event>(events.length);
            for (Event event : events) {
                try {
                    LOG.debug("handling event: {}", (Object)event);
                    this.m_eventForwarder.sendNow(event);
                    if (okEvents.contains(event)) continue;
                    okEvents.add(event);
                }
                catch (Throwable t) {
                    LOG.warn("An exception occured while processing an event.", t);
                }
            }
            boolean hasReceipt = false;
            EventReceipt receipt = new EventReceipt();
            for (Event event : okEvents) {
                if (event.getUuid() == null) continue;
                receipt.addUuid(event.getUuid());
                hasReceipt = true;
            }
            if (hasReceipt) {
                StringWriter writer = new StringWriter();
                JaxbUtils.marshal((Object)receipt, (Writer)writer);
                writer.flush();
                String writerOutput = writer.toString();
                exchange.getOut().setBody((Object)writerOutput);
                LOG.debug("Sent Event Receipt: {}", (Object)writerOutput);
            }
        } else {
            LOG.debug("The agent sent an empty event stream.");
        }
    }
}

