/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.ByteArrayInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.xml.sax.InputSource;

final class UdpReceivedEvent {
    private String m_eventXML;
    private Log m_log;
    private InetAddress m_sender;
    private int m_port;
    private List<Event> m_ackEvents;

    private UdpReceivedEvent() {
    }

    static UdpReceivedEvent make(DatagramPacket packet) {
        return UdpReceivedEvent.make(packet.getAddress(), packet.getPort(), packet.getData(), packet.getLength());
    }

    static UdpReceivedEvent make(InetAddress addr, int port, byte[] data, int len) {
        UdpReceivedEvent e = new UdpReceivedEvent();
        e.m_sender = addr;
        e.m_port = port;
        e.m_eventXML = new String(Arrays.copyOf(data, data.length), 0, len, StandardCharsets.US_ASCII);
        e.m_ackEvents = new ArrayList<Event>(16);
        e.m_log = null;
        return e;
    }

    Log unmarshal() {
        if (this.m_log == null) {
            ByteArrayInputStream is = new ByteArrayInputStream(this.m_eventXML.getBytes());
            this.m_log = (Log)JaxbUtils.unmarshal(Log.class, (InputSource)new InputSource(is));
        }
        return this.m_log;
    }

    void ackEvent(Event e) {
        if (!this.m_ackEvents.contains(e)) {
            this.m_ackEvents.add(e);
        }
    }

    String getXmlData() {
        return this.m_eventXML;
    }

    InetAddress getSender() {
        return this.m_sender;
    }

    int getPort() {
        return this.m_port;
    }

    public List<Event> getAckedEvents() {
        return this.m_ackEvents;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof UdpReceivedEvent) {
            UdpReceivedEvent e = (UdpReceivedEvent)o;
            return this == e || this.m_port == e.m_port && this.m_sender.equals(e.m_sender);
        }
        return false;
    }

    public int hashCode() {
        return this.m_port ^ this.m_sender.hashCode();
    }
}

