/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.api.EventdServiceManager;
import org.opennms.netmgt.eventd.BroadcastEventProcessor;
import org.opennms.netmgt.eventd.adaptors.EventReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class Eventd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Eventd.class);
    public static final String LOG4J_CATEGORY = "eventd";
    private BroadcastEventProcessor m_receiver;
    private EventdServiceManager m_eventdServiceManager;
    private final List<EventReceiver> m_eventReceivers = Collections.synchronizedList(new ArrayList());

    public Eventd() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        Assert.state((this.m_eventdServiceManager != null ? 1 : 0) != 0, (String)"property eventdServiceManager must be set");
        Assert.state((this.m_receiver != null ? 1 : 0) != 0, (String)"property receiver must be set");
        this.m_eventdServiceManager.dataSourceSync();
    }

    protected void onStart() {
        for (EventReceiver eventReceiver : this.m_eventReceivers) {
            eventReceiver.start();
        }
        LOG.debug("Listener threads started");
        LOG.debug("Eventd running");
    }

    protected void onStop() {
        LOG.debug("calling shutdown on tcp/udp listener threads");
        for (EventReceiver eventReceiver : this.m_eventReceivers) {
            eventReceiver.stop();
        }
        if (this.m_receiver != null) {
            this.m_receiver.close();
        }
        LOG.debug("shutdown on tcp/udp listener threads returned");
    }

    public EventdServiceManager getEventdServiceManager() {
        return this.m_eventdServiceManager;
    }

    public void setEventdServiceManager(EventdServiceManager eventdServiceManager) {
        this.m_eventdServiceManager = eventdServiceManager;
    }

    public BroadcastEventProcessor getReceiver() {
        return this.m_receiver;
    }

    public void setReceiver(BroadcastEventProcessor receiver) {
        this.m_receiver = receiver;
    }

    public Collection<EventReceiver> getEventReceivers() {
        return Collections.unmodifiableList(this.m_eventReceivers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventReceivers(Collection<EventReceiver> eventReceivers) {
        List<EventReceiver> list = this.m_eventReceivers;
        synchronized (list) {
            this.m_eventReceivers.clear();
            this.m_eventReceivers.addAll(eventReceivers);
        }
    }
}

