/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.events.api.EventHandler;
import org.opennms.netmgt.events.api.EventIpcBroadcaster;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EventIpcManagerDefaultImpl
implements EventIpcManager,
EventIpcBroadcaster,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EventIpcManagerDefaultImpl.class);
    private Map<String, List<EventListener>> m_ueiListeners = new HashMap<String, List<EventListener>>();
    private List<EventListener> m_listeners = new ArrayList<EventListener>();
    private Map<String, EventListenerExecutor> m_listenerThreads = new HashMap<String, EventListenerExecutor>();
    private ExecutorService m_eventHandlerPool;
    private EventHandler m_eventHandler;
    private Integer m_handlerPoolSize;
    private Integer m_handlerQueueLength;
    private final MetricRegistry m_registry;

    public EventIpcManagerDefaultImpl(MetricRegistry registry) {
        this.m_registry = Objects.requireNonNull(registry);
    }

    public void send(Event event) throws EventProxyException {
        this.sendNow(event);
    }

    public void send(Log eventLog) throws EventProxyException {
        this.sendNow(eventLog);
    }

    public void sendNow(Event event) {
        Assert.notNull((Object)event, (String)"event argument cannot be null");
        Events events = new Events();
        events.addEvent(event);
        Log eventLog = new Log();
        eventLog.setEvents(events);
        this.sendNow(eventLog);
    }

    public void sendNow(Log eventLog) {
        Assert.notNull((Object)eventLog, (String)"eventLog argument cannot be null");
        LOG.debug("sending: {}", (Object)eventLog);
        try {
            this.m_eventHandlerPool.execute(this.m_eventHandler.createRunnable(eventLog));
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Unable to queue event log to the event handler pool queue", (Throwable)e);
            throw e;
        }
    }

    public void sendNowSync(Event event) {
        Objects.requireNonNull(event);
        Events events = new Events();
        events.addEvent(event);
        Log eventLog = new Log();
        eventLog.setEvents(events);
        this.sendNowSync(eventLog);
    }

    public void sendNowSync(Log eventLog) {
        Objects.requireNonNull(eventLog);
        Logging.withPrefix((String)"eventd", (Runnable)this.m_eventHandler.createRunnable(eventLog, true));
    }

    public void broadcastNow(Event event, boolean synchronous) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Event ID {} to be broadcasted: {}", (Object)event.getDbid(), (Object)event.getUei());
        }
        if (LOG.isDebugEnabled() && this.m_listeners.isEmpty()) {
            LOG.debug("No listeners interested in all events");
        }
        ArrayList<CompletableFuture<Void>> listenerFutures = new ArrayList<CompletableFuture<Void>>();
        for (EventListener listener : this.m_listeners) {
            listenerFutures.add(this.queueEventToListener(event, listener));
        }
        if (event.getUei() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Event ID {} does not have a UEI, so skipping UEI matching", (Object)event.getDbid());
            }
            return;
        }
        HashSet<EventListener> sentToListeners = new HashSet<EventListener>();
        String uei = event.getUei();
        while (uei.length() > 0) {
            int i;
            if (this.m_ueiListeners.containsKey(uei)) {
                for (EventListener listener : this.m_ueiListeners.get(uei)) {
                    if (sentToListeners.contains(listener)) continue;
                    listenerFutures.add(this.queueEventToListener(event, listener));
                    sentToListeners.add(listener);
                }
            }
            if ((i = uei.lastIndexOf("/", uei.length() - 2)) <= 0) break;
            uei = uei.substring(0, i + 1);
        }
        if (sentToListeners.isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug("No listener interested in event ID {}: {}", (Object)event.getDbid(), (Object)event.getUei());
        }
        if (synchronous) {
            CompletableFuture.allOf(listenerFutures.toArray(new CompletableFuture[0])).join();
        }
    }

    private CompletableFuture<Void> queueEventToListener(Event event, EventListener listener) {
        return this.m_listenerThreads.get(listener.getName()).addEvent(event);
    }

    public synchronized void addEventListener(EventListener listener) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        this.createListenerThread(listener);
        this.addMatchAllForListener(listener);
        for (String uei : this.m_ueiListeners.keySet()) {
            this.removeUeiForListener(uei, listener);
        }
    }

    public synchronized void addEventListener(EventListener listener, Collection<String> ueis) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        Assert.notNull(ueis, (String)"ueilist argument cannot be null");
        if (ueis.isEmpty()) {
            LOG.warn("Not adding event listener {} because the ueilist argument contains no entries", (Object)listener.getName());
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding event listener {} for UEIs: {}", (Object)listener.getName(), (Object)StringUtils.collectionToCommaDelimitedString(ueis));
        }
        this.createListenerThread(listener);
        for (String uei : ueis) {
            this.addUeiForListener(uei, listener);
        }
        this.removeMatchAllForListener(listener);
    }

    public synchronized void addEventListener(EventListener listener, String uei) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        Assert.notNull((Object)uei, (String)"uei argument cannot be null");
        this.addEventListener(listener, Collections.singletonList(uei));
    }

    public synchronized void removeEventListener(EventListener listener, Collection<String> ueis) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        Assert.notNull(ueis, (String)"ueilist argument cannot be null");
        for (String uei : ueis) {
            this.removeUeiForListener(uei, listener);
        }
    }

    public synchronized void removeEventListener(EventListener listener, String uei) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        Assert.notNull((Object)uei, (String)"uei argument cannot be null");
        this.removeUeiForListener(uei, listener);
    }

    public synchronized void removeEventListener(EventListener listener) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        this.removeMatchAllForListener(listener);
        for (String uei : this.m_ueiListeners.keySet()) {
            this.removeUeiForListener(uei, listener);
        }
        if (this.m_listenerThreads.containsKey(listener.getName())) {
            this.m_listenerThreads.get(listener.getName()).stop();
            this.m_listenerThreads.remove(listener.getName());
        }
    }

    private void createListenerThread(EventListener listener) {
        if (this.m_listenerThreads.containsKey(listener.getName())) {
            return;
        }
        EventListenerExecutor listenerThread = new EventListenerExecutor(listener, this.m_handlerQueueLength);
        this.m_listenerThreads.put(listener.getName(), listenerThread);
    }

    private void addUeiForListener(String uei, EventListener listener) {
        List<EventListener> listenersList;
        if (!this.m_ueiListeners.containsKey(uei)) {
            this.m_ueiListeners.put(uei, new ArrayList());
        }
        if (!(listenersList = this.m_ueiListeners.get(uei)).contains(listener)) {
            listenersList.add(listener);
        }
    }

    private void removeUeiForListener(String uei, EventListener listener) {
        if (this.m_ueiListeners.containsKey(uei)) {
            this.m_ueiListeners.get(uei).remove(listener);
        }
    }

    private boolean addMatchAllForListener(EventListener listener) {
        return this.m_listeners.add(listener);
    }

    private boolean removeMatchAllForListener(EventListener listener) {
        return this.m_listeners.remove(listener);
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_eventHandlerPool == null ? 1 : 0) != 0, (String)"afterPropertiesSet() has already been called");
        Assert.state((this.m_eventHandler != null ? 1 : 0) != 0, (String)"eventHandler not set");
        Assert.state((this.m_handlerPoolSize != null ? 1 : 0) != 0, (String)"handlerPoolSize not set");
        final LinkedBlockingQueue workQueue = this.m_handlerQueueLength == null ? new LinkedBlockingQueue() : new LinkedBlockingQueue(this.m_handlerQueueLength);
        this.m_registry.remove("eventlogs.queued");
        this.m_registry.register("eventlogs.queued", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return workQueue.size();
            }
        });
        Logging.withPrefix((String)"eventd", (Runnable)new Runnable(){

            @Override
            public void run() {
                EventIpcManagerDefaultImpl.this.m_eventHandlerPool = new ThreadPoolExecutor((int)EventIpcManagerDefaultImpl.this.m_handlerPoolSize, (int)EventIpcManagerDefaultImpl.this.m_handlerPoolSize, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)workQueue, (ThreadFactory)new LogPreservingThreadFactory(EventIpcManagerDefaultImpl.class.getSimpleName(), EventIpcManagerDefaultImpl.this.m_handlerPoolSize.intValue()));
            }
        });
    }

    public EventHandler getEventHandler() {
        return this.m_eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.m_eventHandler = eventHandler;
    }

    public int getHandlerPoolSize() {
        return this.m_handlerPoolSize;
    }

    public void setHandlerPoolSize(int handlerPoolSize) {
        Assert.state((this.m_eventHandlerPool == null ? 1 : 0) != 0, (String)"handlerPoolSize property cannot be set after afterPropertiesSet() is called");
        this.m_handlerPoolSize = handlerPoolSize;
    }

    public int getHandlerQueueLength() {
        return this.m_handlerQueueLength;
    }

    public void setHandlerQueueLength(int size) {
        Assert.state((this.m_eventHandlerPool == null ? 1 : 0) != 0, (String)"handlerQueueLength property cannot be set after afterPropertiesSet() is called");
        this.m_handlerQueueLength = size;
    }

    public boolean hasEventListener(String uei) {
        if (this.m_ueiListeners.containsKey(uei)) {
            return this.m_ueiListeners.get(uei).size() > 0;
        }
        return false;
    }

    private static class EventListenerExecutor {
        private final EventListener m_listener;
        private final ExecutorService m_delegateThread;

        EventListenerExecutor(EventListener listener, Integer handlerQueueLength) {
            this.m_listener = listener;
            this.m_delegateThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, handlerQueueLength == null ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(handlerQueueLength), (ThreadFactory)new LogPreservingThreadFactory(this.m_listener.getName(), 1), new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    LOG.warn("Listener {}'s event queue is full, discarding event", (Object)m_listener.getName());
                }
            });
        }

        public CompletableFuture<Void> addEvent(final Event event) {
            return CompletableFuture.runAsync(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOG.debug("run: calling onEvent on {} for event {} dbid {} with time {}", new Object[]{m_listener.getName(), event.getUei(), event.getDbid(), event.getTime()});
                        Map mdc = Logging.getCopyOfContextMap();
                        try {
                            m_listener.onEvent(event);
                        }
                        finally {
                            Logging.setContextMap((Map)mdc);
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn("run: an unexpected error occured during ListenerThread {}", (Object)m_listener.getName(), (Object)t);
                    }
                }
            }, this.m_delegateThread);
        }

        public void stop() {
            this.m_delegateThread.shutdown();
        }
    }

    public static class DiscardTrapsAndSyslogEvents
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }
}

