/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.events.api.EventHandler;
import org.opennms.netmgt.events.api.EventProcessor;
import org.opennms.netmgt.events.api.EventProcessorException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class DefaultEventHandlerImpl
implements InitializingBean,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventHandlerImpl.class);
    private List<EventProcessor> m_eventProcessors;
    private boolean m_logEventSummaries;
    private final Timer processTimer;
    private final Histogram logSizes;

    public DefaultEventHandlerImpl(MetricRegistry registry) {
        this.processTimer = Objects.requireNonNull(registry).timer("eventlogs.process");
        this.logSizes = registry.histogram("eventlogs.sizes");
    }

    public EventHandlerRunnable createRunnable(Log eventLog) {
        return new EventHandlerRunnable(eventLog, false);
    }

    public EventHandlerRunnable createRunnable(Log eventLog, boolean synchronous) {
        return new EventHandlerRunnable(eventLog, synchronous);
    }

    private static List<String> getPrettyParms(Event event) {
        ArrayList<String> parms = new ArrayList<String>();
        for (Parm p : event.getParmCollection()) {
            parms.add(p.getParmName() + "=" + p.getValue().getContent());
        }
        return parms;
    }

    public void afterPropertiesSet() throws IllegalStateException {
        Assert.state((this.m_eventProcessors != null ? 1 : 0) != 0, (String)"property eventPersisters must be set");
    }

    public List<EventProcessor> getEventProcessors() {
        return this.m_eventProcessors;
    }

    public void setEventProcessors(List<EventProcessor> eventProcessors) {
        this.m_eventProcessors = eventProcessors;
    }

    public boolean getLogEventSummaries() {
        return this.m_logEventSummaries;
    }

    public void setLogEventSummaries(boolean logEventSummaries) {
        this.m_logEventSummaries = logEventSummaries;
    }

    private class EventHandlerRunnable
    implements Runnable {
        private final Log m_eventLog;
        private final boolean m_synchronous;

        public EventHandlerRunnable(Log eventLog, boolean synchronous) {
            Assert.notNull((Object)eventLog, (String)"eventLog argument must not be null");
            this.m_eventLog = eventLog;
            this.m_synchronous = synchronous;
        }

        @Override
        public void run() {
            Events events = this.m_eventLog.getEvents();
            if (events == null || events.getEventCount() <= 0) {
                return;
            }
            for (Event event : events.getEventCollection()) {
                if (LOG.isInfoEnabled() && DefaultEventHandlerImpl.this.getLogEventSummaries()) {
                    LOG.info("Received event: UEI={}, src={}, iface={}, svc={}, time={}, parms={}", new Object[]{event.getUei(), event.getSource(), event.getInterface(), event.getService(), event.getTime(), DefaultEventHandlerImpl.getPrettyParms(event)});
                }
                if (!LOG.isDebugEnabled()) continue;
                String uuid = event.getUuid();
                LOG.debug("Event {");
                LOG.debug("  uuid  = {}", (Object)(uuid != null && uuid.length() > 0 ? uuid : "<not-set>"));
                LOG.debug("  uei   = {}", (Object)event.getUei());
                LOG.debug("  src   = {}", (Object)event.getSource());
                LOG.debug("  iface = {}", (Object)event.getInterface());
                LOG.debug("  svc   = {}", (Object)event.getService());
                LOG.debug("  time  = {}", (Object)event.getTime());
                ArrayList parms = new ArrayList(event.getParmCollection());
                if (parms.size() > 0) {
                    LOG.debug("  parms {");
                    for (Parm parm : parms) {
                        if (parm.getParmName() == null || parm.getValue().getContent() == null) continue;
                        LOG.debug("    ({}, {})", (Object)parm.getParmName().trim(), (Object)parm.getValue().getContent().trim());
                    }
                    LOG.debug("  }");
                }
                LOG.debug("}");
            }
            try (Timer.Context context = DefaultEventHandlerImpl.this.processTimer.time();){
                for (EventProcessor eventProcessor : DefaultEventHandlerImpl.this.m_eventProcessors) {
                    try {
                        eventProcessor.process(this.m_eventLog, this.m_synchronous);
                        DefaultEventHandlerImpl.this.logSizes.update(events.getEventCount());
                    }
                    catch (EventProcessorException e) {
                        LOG.warn("Unable to process event using processor {}; not processing with any later processors.", (Object)eventProcessor, (Object)e);
                        break;
                    }
                    catch (Throwable t) {
                        LOG.warn("Unknown exception processing event with processor {}; not processing with any later processors.", (Object)eventProcessor, (Object)t);
                        break;
                    }
                }
            }
        }
    }
}

