/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor.expandable;

import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.processor.expandable.ExpandableParameterResolver;
import org.opennms.netmgt.eventd.processor.expandable.ExpandableToken;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandableParameter
implements ExpandableToken {
    private static final Logger LOG = LoggerFactory.getLogger(ExpandableParameter.class);
    private final String token;
    private final ExpandableParameterResolver resolver;
    private final EventUtil eventUtil;

    public ExpandableParameter(String token, EventUtil eventUtil) {
        this.token = Objects.requireNonNull(token);
        this.resolver = Objects.requireNonNull(eventUtil.getResolver(token));
        this.eventUtil = Objects.requireNonNull(eventUtil);
    }

    @Override
    public String expand(Event event, Map<String, Map<String, String>> decode) {
        String value = this.resolver.getValue(this.token, event, this.eventUtil);
        LOG.debug("Value of token {}={}", (Object)this.token, (Object)value);
        if (value != null) {
            if (decode != null && decode.containsKey(this.token) && decode.get(this.token).containsKey(value)) {
                StringBuilder ret = new StringBuilder();
                ret.append(decode.get(this.token).get(value));
                ret.append("(");
                ret.append(value);
                ret.append(")");
                return ret.toString();
            }
            return value;
        }
        return "";
    }

    @Override
    public boolean requiresTransaction() {
        return this.resolver.requiresTransaction();
    }
}

