/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.List;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UdpReceiver
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UdpReceiver.class);
    private List<UdpReceivedEvent> m_eventsIn;
    private volatile boolean m_stop;
    private DatagramSocket m_dgSock;
    private Thread m_context;
    private String m_logPrefix;

    UdpReceiver(DatagramSocket sock, List<UdpReceivedEvent> xchange) {
        this.m_eventsIn = xchange;
        this.m_stop = false;
        this.m_dgSock = sock;
        this.m_logPrefix = "eventd";
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            LOG.debug("Stopping and joining thread context {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined");
        }
    }

    boolean isAlive() {
        return this.m_context == null ? false : this.m_context.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        Logging.putPrefix((String)this.m_logPrefix);
        if (this.m_stop) {
            LOG.debug("Stop flag set before thread started, exiting");
            return;
        }
        LOG.debug("Thread context started");
        int length = 65535;
        byte[] buffer = new byte[65535];
        DatagramPacket pkt = new DatagramPacket(buffer, 65535);
        try {
            LOG.debug("Setting socket timeout to 500ms");
            this.m_dgSock.setSoTimeout(500);
        }
        catch (SocketException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Setting receive buffer size to {}", (Object)65535);
            this.m_dgSock.setReceiveBufferSize(65535);
        }
        catch (SocketException e) {
            LOG.info("Failed to set the receive buffer to {}", (Object)65535, (Object)e);
        }
        boolean ioInterrupted = false;
        while (!this.m_stop) {
            if (this.m_context.isInterrupted()) {
                LOG.debug("Thread context interrupted");
                break;
            }
            try {
                if (!ioInterrupted) {
                    LOG.debug("Wating on a datagram to arrive");
                }
                this.m_dgSock.receive(pkt);
                ioInterrupted = false;
            }
            catch (InterruptedIOException e) {
                ioInterrupted = true;
                continue;
            }
            catch (IOException e) {
                LOG.error("An I/O exception occured on the datagram receipt port, exiting", (Throwable)e);
                break;
            }
            LOG.debug("Sending received packet to processor");
            UdpReceivedEvent re = UdpReceivedEvent.make(pkt);
            List<UdpReceivedEvent> list = this.m_eventsIn;
            synchronized (list) {
                this.m_eventsIn.add(re);
                this.m_eventsIn.notify();
            }
            pkt = new DatagramPacket(buffer, 65535);
        }
        LOG.debug("Thread context exiting");
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }
}

