/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.MonitoringSystemDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.util.AutoAction;
import org.opennms.netmgt.dao.util.Correlation;
import org.opennms.netmgt.dao.util.Forward;
import org.opennms.netmgt.dao.util.OperatorAction;
import org.opennms.netmgt.dao.util.SnmpInfo;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.processor.EventWriter;
import org.opennms.netmgt.events.api.EventDatabaseConstants;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.events.api.EventProcessorException;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoringSystem;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Operaction;
import org.opennms.netmgt.xml.event.Snmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.util.Assert;

public class HibernateEventWriter
implements EventWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateEventWriter.class);
    public static final String LOG_MSG_DEST_DO_NOT_PERSIST = "donotpersist";
    public static final String LOG_MSG_DEST_SUPRRESS = "suppress";
    public static final String LOG_MSG_DEST_LOG_AND_DISPLAY = "logndisplay";
    public static final String LOG_MSG_DEST_LOG_ONLY = "logonly";
    public static final String LOG_MSG_DEST_DISPLAY_ONLY = "displayonly";
    @Autowired
    private TransactionOperations m_transactionManager;
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private MonitoringSystemDao monitoringSystemDao;
    @Autowired
    private DistPollerDao distPollerDao;
    @Autowired
    private EventDao eventDao;
    @Autowired
    private ServiceTypeDao serviceTypeDao;
    @Autowired
    private EventUtil eventUtil;
    private final Timer writeTimer;

    public HibernateEventWriter(MetricRegistry registry) {
        this.writeTimer = Objects.requireNonNull(registry).timer("eventlogs.process.write");
    }

    private static boolean checkEventSanityAndDoWeProcess(Event event, String logPrefix) {
        Assert.notNull((Object)event, (String)"event argument must not be null");
        Assert.notNull((Object)event.getLogmsg(), (String)"event does not have a logmsg");
        if (LOG_MSG_DEST_DO_NOT_PERSIST.equalsIgnoreCase(event.getLogmsg().getDest()) || LOG_MSG_DEST_SUPRRESS.equalsIgnoreCase(event.getLogmsg().getDest())) {
            LOG.debug("{}: uei '{}' marked as '{}'; not processing event.", new Object[]{logPrefix, event.getUei(), event.getLogmsg().getDest()});
            return false;
        }
        return true;
    }

    public void process(Log eventLog, boolean synchronous) throws EventProcessorException {
        this.process(eventLog);
    }

    public void process(final Log eventLog) throws EventProcessorException {
        if (eventLog != null && eventLog.getEvents() != null) {
            List eventsInLog = eventLog.getEvents().getEventCollection();
            if (eventsInLog == null) {
                return;
            }
            final List eventsToPersist = eventsInLog.stream().filter(e -> HibernateEventWriter.checkEventSanityAndDoWeProcess(e, "HibernateEventWriter")).collect(Collectors.toList());
            if (eventsToPersist.size() < 1) {
                return;
            }
            try (Timer.Context context = this.writeTimer.time();){
                final AtomicReference exception = new AtomicReference();
                this.m_transactionManager.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        for (Event eachEvent : eventsToPersist) {
                            try {
                                HibernateEventWriter.this.process(eventLog.getHeader(), eachEvent);
                            }
                            catch (EventProcessorException e) {
                                exception.set(e);
                                return;
                            }
                        }
                    }
                });
                if (exception.get() != null) {
                    throw (EventProcessorException)((Object)exception.get());
                }
            }
        }
    }

    private void process(Header eventHeader, Event event) throws EventProcessorException {
        LOG.debug("HibernateEventWriter: processing {}, nodeid: {}, ipaddr: {}, serviceid: {}, time: {}", new Object[]{event.getUei(), event.getNodeid(), event.getInterface(), event.getService(), event.getTime()});
        try {
            OnmsEvent ovent = this.createOnmsEvent(eventHeader, event);
            this.eventDao.save((Object)ovent);
            event.setDbid(ovent.getId());
        }
        catch (DeadlockLoserDataAccessException e) {
            throw new EventProcessorException("Encountered deadlock when inserting event: " + event.toString(), (Throwable)e);
        }
        catch (Throwable e) {
            throw new EventProcessorException("Unexpected exception while storing event: " + event.toString(), e);
        }
    }

    private OnmsEvent createOnmsEvent(Header eventHeader, Event event) {
        OnmsEvent ovent = new OnmsEvent();
        ovent.setEventUei(EventDatabaseConstants.format((String)event.getUei(), (int)256));
        if (event.hasNodeid()) {
            ovent.setNode((OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(event.getNodeid().intValue())));
        }
        ovent.setEventTime(event.getTime());
        ovent.setEventHost(EventDatabaseConstants.format((String)this.eventUtil.getEventHost(event), (int)256));
        ovent.setEventSource(EventDatabaseConstants.format((String)event.getSource(), (int)128));
        ovent.setIpAddr(event.getInterfaceAddress());
        if (event.hasIfIndex()) {
            ovent.setIfIndex(event.getIfIndex());
        } else {
            ovent.setIfIndex(null);
        }
        if (eventHeader != null && eventHeader.getDpName() != null && !"".equals(eventHeader.getDpName().trim())) {
            ovent.setDistPoller((OnmsMonitoringSystem)this.distPollerDao.get((Serializable)((Object)eventHeader.getDpName())));
        }
        if (ovent.getDistPoller() == null && event.getDistPoller() != null && !"".equals(event.getDistPoller().trim())) {
            ovent.setDistPoller((OnmsMonitoringSystem)this.monitoringSystemDao.get((Serializable)((Object)event.getDistPoller())));
        }
        if (ovent.getDistPoller() == null) {
            ovent.setDistPoller((OnmsMonitoringSystem)this.distPollerDao.whoami());
        }
        ovent.setEventSnmpHost(EventDatabaseConstants.format((String)event.getSnmphost(), (int)256));
        ovent.setServiceType(this.serviceTypeDao.findByName(event.getService()));
        ovent.setEventSnmp(event.getSnmp() == null ? null : SnmpInfo.format((Snmp)event.getSnmp(), (int)256));
        String parametersString = EventParameterUtils.format((Event)event);
        ovent.setEventParms(EventDatabaseConstants.format((String)parametersString, (int)0));
        ovent.setEventCreateTime(new Date());
        ovent.setEventDescr(EventDatabaseConstants.format((String)event.getDescr(), (int)0));
        ovent.setEventLogGroup(event.getLoggroupCount() > 0 ? EventDatabaseConstants.format((String[])event.getLoggroup(), (int)32) : null);
        if (event.getLogmsg() != null) {
            ovent.setEventLogMsg(EventDatabaseConstants.format((String)event.getLogmsg().getContent(), (int)0));
            String logdest = event.getLogmsg().getDest();
            if (LOG_MSG_DEST_LOG_AND_DISPLAY.equals(logdest)) {
                ovent.setEventLog(String.valueOf('Y'));
                ovent.setEventDisplay(String.valueOf('Y'));
            } else if (LOG_MSG_DEST_LOG_ONLY.equals(logdest)) {
                ovent.setEventLog(String.valueOf('Y'));
                ovent.setEventDisplay(String.valueOf('N'));
            } else if (LOG_MSG_DEST_DISPLAY_ONLY.equals(logdest)) {
                ovent.setEventLog(String.valueOf('N'));
                ovent.setEventDisplay(String.valueOf('Y'));
            } else if (LOG_MSG_DEST_SUPRRESS.equals(logdest)) {
                ovent.setEventLog(String.valueOf('N'));
                ovent.setEventDisplay(String.valueOf('N'));
            }
        } else {
            ovent.setEventLogMsg(null);
            ovent.setEventLog(String.valueOf('Y'));
            ovent.setEventDisplay(String.valueOf('Y'));
        }
        ovent.setEventSeverity(Integer.valueOf(OnmsSeverity.get((String)event.getSeverity()).getId()));
        ovent.setEventPathOutage(event.getPathoutage() != null ? EventDatabaseConstants.format((String)event.getPathoutage(), (int)1024) : null);
        ovent.setEventCorrelation(event.getCorrelation() != null ? Correlation.format((org.opennms.netmgt.xml.event.Correlation)event.getCorrelation(), (int)1024) : null);
        ovent.setEventSuppressedCount(null);
        ovent.setEventOperInstruct(EventDatabaseConstants.format((String)event.getOperinstruct(), (int)0));
        ovent.setEventAutoAction(event.getAutoactionCount() > 0 ? AutoAction.format((Autoaction[])event.getAutoaction(), (int)256) : null);
        if (event.getOperactionCount() > 0) {
            ArrayList<Operaction> a = new ArrayList<Operaction>();
            ArrayList<String> b = new ArrayList<String>();
            for (Operaction eoa : event.getOperactionCollection()) {
                a.add(eoa);
                b.add(eoa.getMenutext());
            }
            ovent.setEventOperAction(OperatorAction.format(a, (int)256));
            ovent.setEventOperActionMenuText(EventDatabaseConstants.format(b, (int)256));
        } else {
            ovent.setEventOperAction(null);
            ovent.setEventOperActionMenuText(null);
        }
        ovent.setEventNotification(null);
        if (event.getTticket() != null) {
            ovent.setEventTTicket(EventDatabaseConstants.format((String)event.getTticket().getContent(), (int)128));
            ovent.setEventTTicketState(Integer.valueOf("on".equals(event.getTticket().getState()) ? 1 : 0));
        } else {
            ovent.setEventTTicket(null);
            ovent.setEventTTicketState(null);
        }
        ovent.setEventForward(event.getForwardCount() > 0 ? Forward.format((org.opennms.netmgt.xml.event.Forward[])event.getForward(), (int)256) : null);
        ovent.setEventMouseOverText(EventDatabaseConstants.format((String)event.getMouseovertext(), (int)64));
        if (event.getAutoacknowledge() != null && "on".equals(event.getAutoacknowledge().getState())) {
            ovent.setEventAckUser(EventDatabaseConstants.format((String)event.getAutoacknowledge().getContent(), (int)256));
            ovent.setEventAckTime(ovent.getEventCreateTime());
        } else {
            ovent.setEventAckUser(null);
            ovent.setEventAckTime(null);
        }
        return ovent;
    }

    public void setTransactionManager(TransactionOperations transactionManager) {
        this.m_transactionManager = transactionManager;
    }
}

