/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.net.InetAddress;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.eventd.AbstractEventUtil;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.processor.expandable.ExpandableParameterResolver;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Tticket;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.LoggerFactory;

public enum StandardExpandableParameterResolvers implements ExpandableParameterResolver
{
    UEI{

        @Override
        public boolean matches(String parm) {
            return "uei".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getUei();
        }
    }
    ,
    DB_ID{

        @Override
        public boolean matches(String parm) {
            return "eventid".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            if (event.hasDbid()) {
                return Integer.toString(event.getDbid());
            }
            return "eventid-unknown";
        }
    }
    ,
    SOURCE{

        @Override
        public boolean matches(String parm) {
            return "source".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getSource();
        }
    }
    ,
    DPNAME{

        @Override
        public boolean matches(String parm) {
            return "dpname".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getDistPoller();
        }
    }
    ,
    DESCR{

        @Override
        public boolean matches(String parm) {
            return "descr".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getDescr();
        }
    }
    ,
    LOGMSG{

        @Override
        public boolean matches(String parm) {
            return "logmsg".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getLogmsg().getContent();
        }
    }
    ,
    NODE_ID{

        @Override
        public boolean matches(String parm) {
            return "nodeid".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return Long.toString(event.getNodeid());
        }
    }
    ,
    TIME{

        @Override
        public boolean matches(String parm) {
            return "time".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Date eventTime = event.getTime();
            if (eventTime != null) {
                DateFormat df = DateFormat.getDateTimeInstance(0, 0);
                return df.format(eventTime);
            }
            return null;
        }
    }
    ,
    SHORT_TIME{

        @Override
        public boolean matches(String parm) {
            return "shorttime".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Date eventTime = event.getTime();
            if (eventTime != null) {
                DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                return df.format(eventTime);
            }
            return null;
        }
    }
    ,
    HOST{

        @Override
        public boolean matches(String parm) {
            return "host".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getHost();
        }
    }
    ,
    INTERFACE{

        @Override
        public boolean matches(String parm) {
            return "interface".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getInterface();
        }
    }
    ,
    IFINDEX{

        @Override
        public boolean matches(String parm) {
            return "ifindex".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            if (event.hasIfIndex()) {
                return Integer.toString(event.getIfIndex());
            }
            return "N/A";
        }
    }
    ,
    INTERFACE_ADDRESS{

        @Override
        public boolean matches(String parm) {
            return "interfaceresolve".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            InetAddress addr = event.getInterfaceAddress();
            if (addr != null) {
                return addr.getHostName();
            }
            return null;
        }
    }
    ,
    SNMP_HOST{

        @Override
        public boolean matches(String parm) {
            return "snmphost".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getSnmphost();
        }
    }
    ,
    SERVICE{

        @Override
        public boolean matches(String parm) {
            return "service".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getService();
        }
    }
    ,
    SNMP{

        @Override
        public boolean matches(String parm) {
            return "snmp".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Snmp info = event.getSnmp();
            if (info != null) {
                StringBuffer snmpStr = new StringBuffer(info.getId());
                if (info.getIdtext() != null) {
                    snmpStr.append(',' + AbstractEventUtil.escape(info.getIdtext().trim(), ','));
                } else {
                    snmpStr.append(",undefined");
                }
                snmpStr.append(',' + info.getVersion());
                if (info.hasSpecific()) {
                    snmpStr.append(',' + Integer.toString(info.getSpecific()));
                } else {
                    snmpStr.append(",undefined");
                }
                if (info.hasGeneric()) {
                    snmpStr.append(',' + Integer.toString(info.getGeneric()));
                } else {
                    snmpStr.append(",undefined");
                }
                if (info.getCommunity() != null) {
                    snmpStr.append(',' + info.getCommunity().trim());
                } else {
                    snmpStr.append(",undefined");
                }
                return snmpStr.toString();
            }
            return null;
        }
    }
    ,
    SNMP_ID{

        @Override
        public boolean matches(String parm) {
            return "id".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Snmp info = event.getSnmp();
            if (info != null) {
                return info.getId();
            }
            return null;
        }
    }
    ,
    SNMP_IDTEXT{

        @Override
        public boolean matches(String parm) {
            return "idtext".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Snmp info = event.getSnmp();
            if (info != null && info.getIdtext() != null) {
                return info.getIdtext();
            }
            return null;
        }
    }
    ,
    SNMP_VERSION{

        @Override
        public boolean matches(String parm) {
            return "version".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Snmp info = event.getSnmp();
            if (info != null) {
                return info.getVersion();
            }
            return null;
        }
    }
    ,
    SNMP_SPECIFIC{

        @Override
        public boolean matches(String parm) {
            return "specific".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Snmp info = event.getSnmp();
            if (info != null && info.hasSpecific()) {
                return Integer.toString(info.getSpecific());
            }
            return null;
        }
    }
    ,
    SNMP_GENERIC{

        @Override
        public boolean matches(String parm) {
            return "generic".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Snmp info = event.getSnmp();
            if (info != null && info.hasGeneric()) {
                return Integer.toString(info.getGeneric());
            }
            return null;
        }
    }
    ,
    SNMP_COMMUNITY{

        @Override
        public boolean matches(String parm) {
            return "community".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Snmp info = event.getSnmp();
            if (info != null && info.getCommunity() != null) {
                return info.getCommunity();
            }
            return null;
        }
    }
    ,
    SEVERITY{

        @Override
        public boolean matches(String parm) {
            return "severity".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getSeverity();
        }
    }
    ,
    OPERINSTRUCT{

        @Override
        public boolean matches(String parm) {
            return "operinstruct".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getOperinstruct();
        }
    }
    ,
    MOUSE_OVER_TEXT{

        @Override
        public boolean matches(String parm) {
            return "mouseovertext".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return event.getMouseovertext();
        }
    }
    ,
    TTICKET_ID{

        @Override
        public boolean matches(String parm) {
            return "tticketid".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            Tticket ticket = event.getTticket();
            return ticket == null ? "" : ticket.getContent();
        }
    }
    ,
    PARMS_VALUES{

        @Override
        public boolean matches(String parm) {
            return "parm[values-all]".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return AbstractEventUtil.getAllParmValues(event);
        }
    }
    ,
    PARMS_NAMES{

        @Override
        public boolean matches(String parm) {
            return "parm[names-all]".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return AbstractEventUtil.getAllParmNames(event);
        }
    }
    ,
    PARMS_ALL{

        @Override
        public boolean matches(String parm) {
            return "parm[all]".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return AbstractEventUtil.getAllParamValues(event);
        }
    }
    ,
    NUM_PARAMS{

        @Override
        public boolean matches(String parm) {
            return "parm[##]".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return String.valueOf(event.getParmCollection().size());
        }
    }
    ,
    PARM_NUM{

        @Override
        public boolean matches(String parm) {
            return parm.startsWith("parm[#");
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return AbstractEventUtil.getNumParmValue(parm, event);
        }
    }
    ,
    PARM_NAME_NUMBERED{

        @Override
        public boolean matches(String parm) {
            return parm.startsWith("parm[name-#");
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            return AbstractEventUtil.getNumParmName(parm, event);
        }
    }
    ,
    PARM{

        @Override
        public boolean matches(String parm) {
            return AbstractEventUtil.PARM_REGEX.matcher(parm).matches();
        }

        @Override
        public String parse(String parm) {
            Matcher m = AbstractEventUtil.PARM_REGEX.matcher(parm);
            if (!m.matches()) {
                throw new IllegalStateException("parse() should not be called if matches() returned false");
            }
            return m.group(1);
        }

        @Override
        public String getValue(String parm, String parmName, Event event, EventUtil eventUtil) {
            Value eParmVal;
            Parm evParm = event.getParmTrim(parmName);
            if (evParm != null && (eParmVal = evParm.getValue()) != null) {
                return EventConstants.getValueAsString((Value)eParmVal);
            }
            return null;
        }
    }
    ,
    HARDWARE{

        @Override
        public boolean matches(String parm) {
            return parm.startsWith("hardware[");
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            String hwFieldValue;
            if (event.getNodeid() != null && (hwFieldValue = eventUtil.getHardwareFieldValue(parm, event.getNodeid())) != null) {
                return hwFieldValue;
            }
            return "Unknown";
        }

        @Override
        public boolean requiresTransaction() {
            return true;
        }
    }
    ,
    ASSET{

        @Override
        public boolean matches(String parm) {
            return parm.startsWith("asset[");
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            String assetFieldValue;
            if (event.getNodeid() != null && (assetFieldValue = eventUtil.getAssetFieldValue(parm, event.getNodeid())) != null) {
                return assetFieldValue;
            }
            return "Unknown";
        }

        @Override
        public boolean requiresTransaction() {
            return true;
        }
    }
    ,
    NODE_LABEL{

        @Override
        public boolean matches(String parm) {
            return "nodelabel".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            String nodeLabel = null;
            if (event.hasNodeid()) {
                try {
                    nodeLabel = eventUtil.getNodeLabel(event.getNodeid());
                }
                catch (SQLException e) {
                    LoggerFactory.getLogger(this.getClass()).info("Node Label unavailable for node with id: {}", (Object)event.getNodeid(), (Object)e);
                }
            }
            if (nodeLabel != null) {
                return WebSecurityUtils.sanitizeString(nodeLabel);
            }
            return "Unknown";
        }

        @Override
        public boolean requiresTransaction() {
            return true;
        }
    }
    ,
    NODE_LOCATION{

        @Override
        public boolean matches(String parm) {
            return "nodelocation".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            String nodeLocation = null;
            if (event.hasNodeid()) {
                try {
                    nodeLocation = eventUtil.getNodeLocation(event.getNodeid());
                }
                catch (SQLException e) {
                    LoggerFactory.getLogger(this.getClass()).info("Node Location unavailable for node with id: {}", (Object)event.getNodeid(), (Object)e);
                }
            }
            if (nodeLocation != null) {
                return WebSecurityUtils.sanitizeString(nodeLocation);
            }
            return "Unknown";
        }

        @Override
        public boolean requiresTransaction() {
            return true;
        }
    }
    ,
    FOREIGN_SOURCE{

        @Override
        public boolean matches(String parm) {
            return "foreignsource".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            if (event.hasNodeid()) {
                try {
                    String foreignSource = eventUtil.getForeignSource(event.getNodeid());
                    if (foreignSource != null) {
                        return WebSecurityUtils.sanitizeString((String)foreignSource);
                    }
                }
                catch (SQLException ex) {
                    LoggerFactory.getLogger(this.getClass()).info("ForeignSource unavailable for node with id:", (Object)event.getNodeid(), (Object)ex);
                }
            }
            return "";
        }

        @Override
        public boolean requiresTransaction() {
            return true;
        }
    }
    ,
    FOREIGN_ID{

        @Override
        public boolean matches(String parm) {
            return "foreignid".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            if (event.hasNodeid()) {
                try {
                    String foreignId = eventUtil.getForeignId(event.getNodeid());
                    if (foreignId != null) {
                        return WebSecurityUtils.sanitizeString((String)foreignId);
                    }
                }
                catch (SQLException ex) {
                    LoggerFactory.getLogger(this.getClass()).info("ForeignId unavailable for node with id:", (Object)event.getNodeid(), (Object)ex);
                }
            }
            return "";
        }

        @Override
        public boolean requiresTransaction() {
            return true;
        }
    }
    ,
    IF_ALIAS{

        @Override
        public boolean matches(String parm) {
            return "ifalias".equals(parm);
        }

        @Override
        public String getValue(String parm, String parsedParm, Event event, EventUtil eventUtil) {
            if (event.getNodeid() > 0L && event.getInterface() != null) {
                try {
                    return eventUtil.getIfAlias(event.getNodeid(), event.getInterface());
                }
                catch (SQLException e) {
                    LoggerFactory.getLogger(this.getClass()).info("ifAlias Unavailable for {}:{}", new Object[]{event.getNodeid(), event.getInterface(), e});
                }
            }
            return event.getInterface();
        }

        @Override
        public boolean requiresTransaction() {
            return true;
        }
    };


    @Override
    public String parse(String parm) {
        return null;
    }

    @Override
    public boolean requiresTransaction() {
        return false;
    }
}

