/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.events.api.EventProcessor;
import org.opennms.netmgt.events.api.EventProcessorException;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Autoacknowledge;
import org.opennms.netmgt.xml.event.Correlation;
import org.opennms.netmgt.xml.event.Forward;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Mask;
import org.opennms.netmgt.xml.event.Operaction;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Tticket;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xml.eventconf.Autoaction;
import org.opennms.netmgt.xml.eventconf.Decode;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.netmgt.xml.eventconf.Maskelement;
import org.opennms.netmgt.xml.eventconf.Parameter;
import org.opennms.netmgt.xml.eventconf.Script;
import org.opennms.netmgt.xml.eventconf.UpdateField;
import org.opennms.netmgt.xml.eventconf.Varbindsdecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class EventExpander
implements org.opennms.netmgt.dao.api.EventExpander,
EventProcessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EventExpander.class);
    private EventConfDao m_eventConfDao;
    private EventUtil m_eventUtil;
    private static final String DEFAULT_EVENT_UEI = "uei.opennms.org/default/event";
    private final Timer expandTimer;

    public EventExpander(MetricRegistry registry) {
        this.expandTimer = Objects.requireNonNull(registry).timer("eventlogs.process.expand");
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_eventConfDao != null ? 1 : 0) != 0, (String)"property eventConfDao must be set");
        Assert.state((this.m_eventUtil != null ? 1 : 0) != 0, (String)"property eventUtil must be set");
    }

    private Mask transform(org.opennms.netmgt.xml.eventconf.Mask src) {
        Mask dest = new Mask();
        Enumeration en = src.enumerateMaskelement();
        while (en.hasMoreElements()) {
            String[] confmevalues;
            Maskelement confme = (Maskelement)en.nextElement();
            org.opennms.netmgt.xml.event.Maskelement me = new org.opennms.netmgt.xml.event.Maskelement();
            me.setMename(confme.getMename());
            for (String confmevalue : confmevalues = confme.getMevalue()) {
                me.addMevalue(confmevalue);
            }
            dest.addMaskelement(me);
        }
        return dest;
    }

    private Snmp transform(org.opennms.netmgt.xml.eventconf.Snmp src) {
        Snmp dest = new Snmp();
        dest.setId(src.getId());
        dest.setIdtext(src.getIdtext());
        dest.setVersion(src.getVersion());
        dest.setCommunity(src.getCommunity());
        if (src.hasGeneric()) {
            dest.setGeneric(src.getGeneric());
        }
        if (src.hasSpecific()) {
            dest.setSpecific(src.getSpecific());
        }
        return dest;
    }

    private org.opennms.netmgt.xml.event.Logmsg transform(Logmsg src) {
        org.opennms.netmgt.xml.event.Logmsg dest = new org.opennms.netmgt.xml.event.Logmsg();
        dest.setContent(src.getContent());
        dest.setDest(src.getDest());
        dest.setNotify(src.getNotify());
        return dest;
    }

    private Correlation transform(org.opennms.netmgt.xml.eventconf.Correlation src) {
        Correlation dest = new Correlation();
        dest.setCuei(src.getCuei());
        dest.setCmin(src.getCmin());
        dest.setCmax(src.getCmax());
        dest.setCtime(src.getCtime());
        dest.setState(src.getState());
        dest.setPath(src.getPath());
        return dest;
    }

    private org.opennms.netmgt.xml.event.Autoaction transform(Autoaction src) {
        org.opennms.netmgt.xml.event.Autoaction dest = new org.opennms.netmgt.xml.event.Autoaction();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        return dest;
    }

    private Operaction transform(org.opennms.netmgt.xml.eventconf.Operaction src) {
        Operaction dest = new Operaction();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        dest.setMenutext(src.getMenutext());
        return dest;
    }

    private Autoacknowledge transform(org.opennms.netmgt.xml.eventconf.Autoacknowledge src) {
        Autoacknowledge dest = new Autoacknowledge();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        return dest;
    }

    private Tticket transform(org.opennms.netmgt.xml.eventconf.Tticket src) {
        Tticket dest = new Tticket();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        return dest;
    }

    private Forward transform(org.opennms.netmgt.xml.eventconf.Forward src) {
        Forward dest = new Forward();
        dest.setContent(src.getContent());
        dest.setState(src.getState());
        dest.setMechanism(src.getMechanism());
        return dest;
    }

    private org.opennms.netmgt.xml.event.Script transform(Script src) {
        org.opennms.netmgt.xml.event.Script dest = new org.opennms.netmgt.xml.event.Script();
        dest.setContent(src.getContent());
        dest.setLanguage(src.getLanguage());
        return dest;
    }

    public static Event lookup(EventConfDao dao, org.opennms.netmgt.xml.event.Event event) {
        if (event == null) {
            throw new NullPointerException("Invalid argument, the event parameter must not be null");
        }
        Event eConf = null;
        eConf = dao.findByEvent(event);
        if (eConf == null) {
            eConf = dao.findByUei(DEFAULT_EVENT_UEI);
        }
        return eConf;
    }

    private void expandParms(org.opennms.netmgt.xml.event.Logmsg logmsg, org.opennms.netmgt.xml.event.Event event, Map<String, Map<String, String>> decode) {
        String strRet = this.m_eventUtil.expandParms(logmsg.getContent(), event, decode);
        if (strRet != null) {
            logmsg.setContent(strRet);
        }
    }

    private void expandParms(org.opennms.netmgt.xml.event.Autoaction[] autoactions, org.opennms.netmgt.xml.event.Event event) {
        boolean expanded = false;
        for (org.opennms.netmgt.xml.event.Autoaction action : autoactions) {
            String strRet = this.m_eventUtil.expandParms(action.getContent(), event);
            if (strRet == null) continue;
            action.setContent(strRet);
            expanded = true;
        }
        if (expanded) {
            event.setAutoaction(autoactions);
        }
    }

    private void expandParms(Operaction[] operactions, org.opennms.netmgt.xml.event.Event event) {
        boolean expanded = false;
        for (Operaction action : operactions) {
            String strRet = this.m_eventUtil.expandParms(action.getContent(), event);
            if (strRet == null) continue;
            action.setContent(strRet);
            expanded = true;
        }
        if (expanded) {
            event.setOperaction(operactions);
        }
    }

    private void expandParms(Tticket tticket, org.opennms.netmgt.xml.event.Event event) {
        String strRet = this.m_eventUtil.expandParms(tticket.getContent(), event);
        if (strRet != null) {
            tticket.setContent(strRet);
        }
    }

    private void expandParms(org.opennms.netmgt.xml.event.Event event, Map<String, Map<String, String>> decode) {
        String strRet = null;
        if (event.getParmCollection() != null && event.getParmCollection().size() > 0) {
            event.getParmCollection().stream().map(p -> p.getValue()).filter(v -> v.isExpand()).forEach(v -> {
                String str = this.m_eventUtil.expandParms(v.getContent(), event, decode);
                if (str != null) {
                    v.setContent(str);
                }
            });
        }
        if (event.getDescr() != null && (strRet = this.m_eventUtil.expandParms(event.getDescr(), event, decode)) != null) {
            event.setDescr(strRet);
            strRet = null;
        }
        if (event.getLogmsg() != null) {
            this.expandParms(event.getLogmsg(), event, decode);
        }
        if (event.getOperinstruct() != null && (strRet = this.m_eventUtil.expandParms(event.getOperinstruct(), event)) != null) {
            event.setOperinstruct(strRet);
            strRet = null;
        }
        if (event.getAutoaction() != null) {
            this.expandParms(event.getAutoaction(), event);
        }
        if (event.getOperaction() != null) {
            this.expandParms(event.getOperaction(), event);
        }
        if (event.getTticket() != null) {
            this.expandParms(event.getTticket(), event);
        }
        if (event.getAlarmData() != null) {
            strRet = this.m_eventUtil.expandParms(event.getAlarmData().getReductionKey(), event);
            if (strRet != null) {
                event.getAlarmData().setReductionKey(strRet);
            }
            strRet = null;
            strRet = this.m_eventUtil.expandParms(event.getAlarmData().getClearKey(), event);
            if (strRet != null) {
                event.getAlarmData().setClearKey(strRet);
            }
        }
    }

    public void expandEvent(org.opennms.netmgt.xml.event.Event e) {
        Event econf = EventExpander.lookup(this.m_eventConfDao, e);
        if (econf != null) {
            Autoaction src;
            Enumeration eter;
            if (this.m_eventConfDao.isSecureTag("mask")) {
                e.setMask(null);
            }
            if (e.getMask() == null && econf.getMask() != null) {
                e.setMask(this.transform(econf.getMask()));
            }
            if (e.getUei() == null) {
                e.setUei(econf.getUei());
            }
            if (e.getSnmp() == null && econf.getSnmp() != null) {
                e.setSnmp(this.transform(econf.getSnmp()));
            }
            if (this.m_eventConfDao.isSecureTag("descr")) {
                e.setDescr(null);
            }
            if (e.getDescr() == null && econf.getDescr() != null) {
                e.setDescr(econf.getDescr());
            }
            if (this.m_eventConfDao.isSecureTag("logmsg")) {
                e.setLogmsg(null);
            }
            if (e.getLogmsg() == null && econf.getLogmsg() != null) {
                e.setLogmsg(this.transform(econf.getLogmsg()));
            }
            if (this.m_eventConfDao.isSecureTag("severity")) {
                e.setSeverity(null);
            }
            if (e.getSeverity() == null && econf.getSeverity() != null) {
                e.setSeverity(econf.getSeverity());
            }
            if (this.m_eventConfDao.isSecureTag("correlation")) {
                e.setCorrelation(null);
            }
            if (e.getCorrelation() == null && econf.getCorrelation() != null) {
                e.setCorrelation(this.transform(econf.getCorrelation()));
            }
            if (this.m_eventConfDao.isSecureTag("operinstruct")) {
                e.setOperinstruct(null);
            }
            if (e.getOperinstruct() == null && econf.getOperinstruct() != null) {
                e.setOperinstruct(econf.getOperinstruct());
            }
            if (this.m_eventConfDao.isSecureTag("autoaction")) {
                e.removeAllAutoaction();
            }
            if (e.getAutoactionCount() == 0 && econf.getAutoactionCount() > 0) {
                eter = econf.enumerateAutoaction();
                while (eter.hasMoreElements()) {
                    src = (Autoaction)eter.nextElement();
                    e.addAutoaction(this.transform(src));
                }
            }
            if (this.m_eventConfDao.isSecureTag("operaction")) {
                e.removeAllOperaction();
            }
            if (e.getOperactionCount() == 0 && econf.getOperactionCount() > 0) {
                eter = econf.enumerateOperaction();
                while (eter.hasMoreElements()) {
                    src = (org.opennms.netmgt.xml.eventconf.Operaction)eter.nextElement();
                    e.addOperaction(this.transform((org.opennms.netmgt.xml.eventconf.Operaction)src));
                }
            }
            if (this.m_eventConfDao.isSecureTag("autoacknowledge")) {
                e.setAutoacknowledge(null);
            }
            if (e.getAutoacknowledge() == null && econf.getAutoacknowledge() != null) {
                e.setAutoacknowledge(this.transform(econf.getAutoacknowledge()));
            }
            if (this.m_eventConfDao.isSecureTag("loggroup")) {
                e.removeAllLoggroup();
            }
            if (e.getLoggroupCount() == 0 && econf.getLoggroupCount() > 0) {
                e.setLoggroup(econf.getLoggroup());
            }
            if (this.m_eventConfDao.isSecureTag("tticket")) {
                e.setTticket(null);
            }
            if (e.getTticket() == null && econf.getTticket() != null) {
                e.setTticket(this.transform(econf.getTticket()));
            }
            if (this.m_eventConfDao.isSecureTag("forward")) {
                e.removeAllForward();
            }
            if (e.getForwardCount() == 0 && econf.getForwardCount() > 0) {
                eter = econf.enumerateForward();
                while (eter.hasMoreElements()) {
                    src = (org.opennms.netmgt.xml.eventconf.Forward)eter.nextElement();
                    e.addForward(this.transform((org.opennms.netmgt.xml.eventconf.Forward)src));
                }
            }
            if (this.m_eventConfDao.isSecureTag("script")) {
                e.removeAllScript();
            }
            if (e.getScriptCount() == 0 && econf.getScriptCount() > 0) {
                eter = econf.enumerateScript();
                while (eter.hasMoreElements()) {
                    src = (Script)eter.nextElement();
                    e.addScript(this.transform((Script)src));
                }
            }
            if (this.m_eventConfDao.isSecureTag("mouseovertext")) {
                e.setMouseovertext(null);
            }
            if (e.getMouseovertext() == null && econf.getMouseovertext() != null) {
                e.setMouseovertext(econf.getMouseovertext());
            }
            if (e.getAlarmData() == null && econf.getAlarmData() != null) {
                AlarmData alarmData = new AlarmData();
                alarmData.setAlarmType(econf.getAlarmData().getAlarmType());
                alarmData.setReductionKey(econf.getAlarmData().getReductionKey());
                alarmData.setAutoClean(econf.getAlarmData().getAutoClean());
                alarmData.setX733AlarmType(econf.getAlarmData().getX733AlarmType());
                alarmData.setX733ProbableCause(econf.getAlarmData().getX733ProbableCause());
                alarmData.setClearKey(econf.getAlarmData().getClearKey());
                List updateFieldList = econf.getAlarmData().getUpdateFieldList();
                if (updateFieldList.size() > 0) {
                    ArrayList<org.opennms.netmgt.xml.event.UpdateField> updateFields = new ArrayList<org.opennms.netmgt.xml.event.UpdateField>(updateFieldList.size());
                    for (UpdateField econfUpdateField : updateFieldList) {
                        org.opennms.netmgt.xml.event.UpdateField eventField = new org.opennms.netmgt.xml.event.UpdateField();
                        eventField.setFieldName(econfUpdateField.getFieldName());
                        eventField.setUpdateOnReduction(econfUpdateField.isUpdateOnReduction());
                        updateFields.add(eventField);
                    }
                    alarmData.setUpdateField(updateFields);
                }
                e.setAlarmData(alarmData);
            }
            if (econf.getParameterCollection() != null && econf.getParameterCount() > 0) {
                if (e.getParmCollection() == null) {
                    e.setParmCollection(new ArrayList(econf.getParameterCount()));
                }
                for (Parameter p : econf.getParameterCollection()) {
                    if (EventUtils.getParm((org.opennms.netmgt.xml.event.Event)e, (String)p.getName()) == null) {
                        Parm parm = new Parm();
                        parm.setParmName(p.getName());
                        Value v = new Value();
                        v.setContent(p.getValue());
                        v.setType("string");
                        v.setEncoding("text");
                        v.setExpand(p.isExpand());
                        parm.setValue(v);
                        e.addParm(parm);
                        continue;
                    }
                    LOG.warn("expandEvent: the event {} already has a parameter named {}, the original content will be preserved. Check the event definition and rename the optional parameter.", (Object)e.getUei(), (Object)p.getName());
                }
            }
        }
        HashMap<String, Map<String, String>> decode = new HashMap<String, Map<String, String>>();
        if (econf != null && econf.getVarbindsdecode() != null) {
            Varbindsdecode[] vardecodeArray;
            for (Varbindsdecode element : vardecodeArray = econf.getVarbindsdecode()) {
                Decode[] decodeArray = element.getDecode();
                HashMap<String, String> valueMap = new HashMap<String, String>();
                for (Decode element2 : decodeArray) {
                    valueMap.put(element2.getVarbindvalue(), element2.getVarbinddecodedstring());
                }
                decode.put(element.getParmid(), valueMap);
            }
        }
        this.expandParms(e, decode);
    }

    public void process(Log eventLog) throws EventProcessorException {
        if (eventLog != null && eventLog.getEvents() != null && eventLog.getEvents().getEvent() != null) {
            try (Timer.Context ctx = this.expandTimer.time();){
                for (org.opennms.netmgt.xml.event.Event event : eventLog.getEvents().getEvent()) {
                    this.expandEvent(event);
                }
            }
        }
    }

    public EventConfDao getEventConfDao() {
        return this.m_eventConfDao;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }

    public void setEventUtil(EventUtil eventUtil) {
        this.m_eventUtil = eventUtil;
    }
}

